/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.rendering;

import com.devbobcorn.nekoration.client.rendering.entities.AbstractPaintingRenderer;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PaintingRendererManager {
    private static final String SAVED_PATH = "nekocache/";
    private static final Logger LOGGER = LogManager.getLogger((String)"Painting Manager");
    private static AbstractPaintingRenderer.PixelsPaintingRenderer PIXELS_RENDERER = new AbstractPaintingRenderer.PixelsPaintingRenderer();
    public static LoadingCache<Integer, AtomicReference<AbstractPaintingRenderer>> PAINTING_RENDERERS = CacheBuilder.newBuilder().removalListener(old -> ((AbstractPaintingRenderer)((AtomicReference)old.getValue()).get()).close()).expireAfterWrite(360000L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Integer, AtomicReference<AbstractPaintingRenderer>>(){

        public AtomicReference<AbstractPaintingRenderer> load(Integer key) throws Exception {
            try {
                AtomicReference<AbstractPaintingRenderer> ref = new AtomicReference<AbstractPaintingRenderer>(PIXELS_RENDERER);
                byte[] bytes = PaintingRendererManager.read(PaintingRendererManager.SAVED_PATH + Integer.toString(key) + ".png");
                NativeImage image = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(bytes));
                RenderSystem.m_69879_(() -> {
                    TextureManager manager = Minecraft.m_91087_().m_91097_();
                    ref.compareAndSet(PIXELS_RENDERER, new AbstractPaintingRenderer.ImagePaintingRenderer(image, manager));
                });
                LOGGER.info("Image #" + key + " Loaded.");
                return ref;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new AtomicReference<AbstractPaintingRenderer>(PIXELS_RENDERER);
            }
        }
    });

    public static AbstractPaintingRenderer.PixelsPaintingRenderer PixelsRenderer() {
        return PIXELS_RENDERER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(String name) {
        FileInputStream input = null;
        ByteArrayOutputStream arrStream = new ByteArrayOutputStream();
        try {
            input = new FileInputStream(name);
            byte[] arr = new byte[65536];
            int len = -1;
            while ((len = ((InputStream)input).read(arr)) != -1) {
                arrStream.write(arr, 0, len);
            }
            byte[] byArray = arrStream.toByteArray();
            return byArray;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Nullable
    public static AbstractPaintingRenderer get(Integer hash) {
        try {
            AtomicReference rd = (AtomicReference)PAINTING_RENDERERS.getIfPresent((Object)hash);
            return rd == null ? (AbstractPaintingRenderer)((AtomicReference)PAINTING_RENDERERS.get((Object)hash)).get() : (AbstractPaintingRenderer)rd.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

