/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.rendering;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkModel {
    private static final Logger LOGGER = LogManager.getLogger((String)"Chunk Model");
    private Level level;
    private BlockPos pos;
    protected int chunkGridSizeY;
    protected int chunkGridSizeX;
    protected int chunkGridSizeZ;
    public ChunkRenderDispatcher.RenderChunk[] chunks;
    private boolean isCompiled = false;
    private boolean isCompiling = false;

    private ChunkModel(Level level, BlockPos pos, ChunkBufferBuilderPack regionRenderCacheBuilder, int radius) {
        this.level = level;
        this.pos = pos;
        this.setAreaRadius(radius);
    }

    public static ChunkModel forTileEntity(Level level, BlockEntity tileEntity, int radius) {
        BlockPos pos = tileEntity.m_58899_();
        ChunkModel model = new ChunkModel(level, pos, new ChunkBufferBuilderPack(), radius);
        return model;
    }

    private int getChunkIndex(int posx, int posy, int posz) {
        return (posz * this.chunkGridSizeY + posy) * this.chunkGridSizeX + posx;
    }

    public ChunkRenderDispatcher.RenderChunk getRenderChunk(int x, int y, int z) {
        return this.chunks[this.getChunkIndex(x, y, z)];
    }

    protected void setAreaRadius(int radius) {
        this.chunkGridSizeX = radius * 2 + 1;
        this.chunkGridSizeZ = radius * 2 + 1;
        this.chunkGridSizeY = this.level.m_151559_();
        ChunkRenderDispatcher dispatcher = Minecraft.m_91087_().f_91060_.m_173015_();
        int count = this.chunkGridSizeX * this.chunkGridSizeY * this.chunkGridSizeZ;
        this.chunks = new ChunkRenderDispatcher.RenderChunk[count];
        int orgX = this.pos.m_123341_() >> 4 << 4;
        int orgY = this.pos.m_123342_() >> 4 << 4;
        int orgZ = this.pos.m_123343_() >> 4 << 4;
        for (int x = 0; x < this.chunkGridSizeX; ++x) {
            for (int y = 0; y < this.chunkGridSizeY; ++y) {
                for (int z = 0; z < this.chunkGridSizeZ; ++z) {
                    int index = this.getChunkIndex(x, y, z);
                    ChunkRenderDispatcher chunkRenderDispatcher = dispatcher;
                    Objects.requireNonNull(chunkRenderDispatcher);
                    this.chunks[index] = new ChunkRenderDispatcher.RenderChunk(chunkRenderDispatcher, index, orgX + x * 16, orgY + y * 16, orgZ + z * 16);
                }
            }
        }
    }

    public void compile(Minecraft mc, BlockPos camPos) {
        this.isCompiling = true;
        RenderRegionCache cache = new RenderRegionCache();
        for (ChunkRenderDispatcher.RenderChunk chunk : this.chunks) {
            ChunkPos chunkpos = new ChunkPos(chunk.m_112839_());
            if (!this.level.m_6325_(chunkpos.f_45578_, chunkpos.f_45579_).m_196863_()) continue;
            mc.f_91060_.m_173015_().m_200431_(chunk, cache);
            this.isCompiled = true;
            LOGGER.info("Chunk model compilation at " + chunkpos + " complete.");
        }
        this.isCompiling = false;
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    public boolean isCompiling() {
        return this.isCompiling;
    }
}

