/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.client.event;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.blocks.DyeableBlock;
import com.devbobcorn.nekoration.blocks.DyeableDoorBlock;
import com.devbobcorn.nekoration.blocks.DyeableHorizontalBlock;
import com.devbobcorn.nekoration.blocks.DyeableVerticalConnectBlock;
import com.devbobcorn.nekoration.blocks.HalfTimberBlock;
import com.devbobcorn.nekoration.blocks.HalfTimberPillarBlock;
import com.devbobcorn.nekoration.blocks.ModBlocks;
import com.devbobcorn.nekoration.blocks.WindowBlock;
import com.devbobcorn.nekoration.blocks.containers.ModMenuType;
import com.devbobcorn.nekoration.blocks.entities.ModBlockEntityType;
import com.devbobcorn.nekoration.client.event.CreativeInventoryEvents;
import com.devbobcorn.nekoration.client.gui.screen.EaselMenuScreen;
import com.devbobcorn.nekoration.client.rendering.blockentities.CupboardRenderer;
import com.devbobcorn.nekoration.client.rendering.blockentities.CustomRenderer;
import com.devbobcorn.nekoration.client.rendering.blockentities.EaselMenuRenderer;
import com.devbobcorn.nekoration.client.rendering.blockentities.PhonographRenderer;
import com.devbobcorn.nekoration.client.rendering.blockentities.PrismapTableRenderer;
import com.devbobcorn.nekoration.client.rendering.entities.PaintingRenderer;
import com.devbobcorn.nekoration.client.rendering.entities.SeatRenderer;
import com.devbobcorn.nekoration.client.rendering.entities.WallPaperRenderer;
import com.devbobcorn.nekoration.entities.ModEntityType;
import com.devbobcorn.nekoration.items.DyeableBlockItem;
import com.devbobcorn.nekoration.items.DyeableWoodenBlockItem;
import com.devbobcorn.nekoration.items.HalfTimberBlockItem;
import com.devbobcorn.nekoration.items.PaintingItem;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="nekoration", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class ClientModEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger((String)"Client Mod Event Subscriber");
    public static final ModelLayerLocation WALLPAPER = ClientModEventSubscriber.createLocation("wallpaper", "main");
    @Nullable
    private static ShaderInstance rendertypeCatPortalShader;

    @SubscribeEvent
    public static void onClientSetupEvent(FMLClientSetupEvent event) {
        LOGGER.info("Client Side Setup.");
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntityType.EASEL_MENU_TYPE.get()), EaselMenuRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntityType.CUSTOM_TYPE.get()), CustomRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntityType.PHONOGRAPH_TYPE.get()), PhonographRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntityType.PRISMAP_TABLE_TYPE.get()), PrismapTableRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntityType.ITEM_DISPLAY_TYPE.get()), CupboardRenderer::new);
        LOGGER.info("BlockEntities Renderers Bound.");
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityType.PAINTING_TYPE.get()), PaintingRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityType.WALLPAPER_TYPE.get()), WallPaperRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityType.SEAT_TYPE.get()), SeatRenderer::new);
        LOGGER.info("Then Entities Renderers Bound.");
        MinecraftForge.EVENT_BUS.register((Object)new CreativeInventoryEvents());
        LOGGER.info("CreativeInv Events Registered.");
        event.enqueueWork(ClientModEventSubscriber::registerPropertyOverrides);
        LOGGER.info("Property Overrides Registered.");
        MenuScreens.m_96206_((MenuType)((MenuType)ModMenuType.EASEL_MENU_TYPE.get()), EaselMenuScreen::new);
        LOGGER.info("Nekoration Screens Registered.");
    }

    public static void exportRenderTypes() {
        File exportFile = new File(Minecraft.m_91087_().f_91069_, "block_render_type.json");
        try {
            Field rtMap = ObfuscationReflectionHelper.findField(ItemBlockRenderTypes.class, (String)"f_109275_");
            rtMap.setAccessible(true);
            Object mapObject = rtMap.get(null);
            Map map = (Map)mapObject;
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            HashMap renderTypeTable = new HashMap();
            map.forEach((b, rt) -> {
                String blockId = ForgeRegistries.BLOCKS.getKey(b).toString();
                String renderType = rt.toString().substring(11).split(":", 2)[0];
                renderTypeTable.put(blockId, renderType);
            });
            if (exportFile.exists() || exportFile.createNewFile()) {
                FileWriter writer = new FileWriter(exportFile);
                writer.write(gson.toJson(renderTypeTable));
                writer.close();
                LOGGER.info("Successfully exported render type table.");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to export render type table: " + e.getMessage());
        }
    }

    public static void exportBlockLists() {
        File exportFile = new File(Minecraft.m_91087_().f_91069_, "block_lists.json");
        try {
            BlockGetter fakeLevel = new BlockGetter(){

                public BlockState m_8055_(BlockPos pos) {
                    return Blocks.f_50016_.m_49966_();
                }

                public FluidState m_6425_(BlockPos pos) {
                    return Fluids.f_76191_.m_76145_();
                }

                public int m_141928_() {
                    return 256;
                }

                public int m_141937_() {
                    return 0;
                }

                public BlockEntity m_7702_(BlockPos pos) {
                    return null;
                }
            };
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            BlockListsExport data = new BlockListsExport();
            Field col = ObfuscationReflectionHelper.findField(BlockBehaviour.class, (String)"f_60443_");
            for (Block block : ForgeRegistries.BLOCKS) {
                ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)block);
                if (blockId.m_135827_() != "minecraft") continue;
                BlockState defoState = block.m_49966_();
                if (!defoState.m_60815_()) {
                    data.no_occlusion.add(blockId.toString());
                }
                if (!((Boolean)col.get(block)).booleanValue()) {
                    data.no_collision.add(blockId.toString());
                }
                if (defoState.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
                    data.water_blocks.add(blockId.toString());
                }
                if (!Block.m_49916_((VoxelShape)defoState.m_60768_(fakeLevel, BlockPos.f_121853_))) continue;
                data.always_fulls.add(blockId.toString());
            }
            if (exportFile.exists() || exportFile.createNewFile()) {
                FileWriter writer = new FileWriter(exportFile);
                writer.write(gson.toJson((Object)data));
                writer.close();
                LOGGER.info("Successfully exported special block lists.");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to export special block lists: " + e.getMessage());
        }
    }

    public static void registerPropertyOverrides() {
        ItemProperties.register((Item)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("nekoration", "awning_pure"))), (ResourceLocation)new ResourceLocation("color"), DyeableBlockItem::getColorPropertyOverride);
        ItemProperties.register((Item)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("nekoration", "awning_stripe"))), (ResourceLocation)new ResourceLocation("color"), DyeableBlockItem::getColorPropertyOverride);
        ItemProperties.register((Item)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("nekoration", "awning_pure_short"))), (ResourceLocation)new ResourceLocation("color"), DyeableBlockItem::getColorPropertyOverride);
        ItemProperties.register((Item)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("nekoration", "awning_stripe_short"))), (ResourceLocation)new ResourceLocation("color"), DyeableBlockItem::getColorPropertyOverride);
        ItemProperties.register((Item)((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("nekoration", "painting"))), (ResourceLocation)new ResourceLocation("type"), PaintingItem::getTypePropertyOverride);
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, view, pos, tintIndex) -> {
            if (view == null || pos == null || !(state.m_60734_() instanceof DyeableBlock)) {
                return NekoColors.getStoneColorOrLightGray(7);
            }
            return NekoColors.getStoneColorOrLightGray((Integer)state.m_61143_((Property)DyeableBlock.COLOR));
        }, new Block[]{(Block)ModBlocks.STONE_BASE_BOTTOM.get(), (Block)ModBlocks.STONE_FRAME_BOTTOM.get(), (Block)ModBlocks.STONE_PILLAR_BOTTOM.get(), (Block)ModBlocks.STONE_LAYERED.get(), (Block)ModBlocks.STONE_POT.get(), (Block)ModBlocks.STONE_PLANTER.get()});
        event.register((state, view, pos, tintIndex) -> {
            if (view == null || pos == null || !(state.m_60734_() instanceof DyeableBlock)) {
                return NekoColors.getNekoColorOrWhite(14);
            }
            return NekoColors.getNekoColorOrWhite((Integer)state.m_61143_((Property)DyeableBlock.COLOR));
        }, new Block[]{(Block)ModBlocks.CANDLE_HOLDER_IRON.get(), (Block)ModBlocks.CANDLE_HOLDER_GOLD.get(), (Block)ModBlocks.CANDLE_HOLDER_QUARTZ.get()});
        event.register((state, view, pos, tintIndex) -> {
            if (view == null || pos == null || !(state.m_60734_() instanceof DyeableBlock)) {
                return NekoColors.getWoodenColorOrBrown(2);
            }
            return NekoColors.getWoodenColorOrBrown((Integer)state.m_61143_((Property)DyeableBlock.COLOR));
        }, new Block[]{(Block)ModBlocks.EASEL_MENU.get(), (Block)ModBlocks.EASEL_MENU_WHITE.get(), (Block)ModBlocks.CUPBOARD.get(), (Block)ModBlocks.SHELF.get(), (Block)ModBlocks.WALL_SHELF.get(), (Block)ModBlocks.GLASS_TABLE.get(), (Block)ModBlocks.GLASS_ROUND_TABLE.get(), (Block)ModBlocks.ARM_CHAIR.get(), (Block)ModBlocks.BENCH.get(), (Block)ModBlocks.DRAWER.get(), (Block)ModBlocks.CABINET.get(), (Block)ModBlocks.DRAWER_CHEST.get()});
        event.register((state, view, pos, tintIndex) -> {
            if (view == null || pos == null || !(state.m_60734_() instanceof DyeableVerticalConnectBlock)) {
                return NekoColors.getStoneColorOrLightGray(7);
            }
            return NekoColors.getStoneColorOrLightGray((Integer)state.m_61143_((Property)DyeableVerticalConnectBlock.COLOR));
        }, new Block[]{(Block)ModBlocks.STONE_BASE.get(), (Block)ModBlocks.STONE_FRAME.get(), (Block)ModBlocks.STONE_PILLAR.get(), (Block)ModBlocks.STONE_DORIC.get(), (Block)ModBlocks.STONE_IONIC.get(), (Block)ModBlocks.STONE_CORINTHIAN.get()});
        event.register((state, view, pos, tintIndex) -> {
            if (view == null || pos == null || !(state.m_60734_() instanceof DyeableHorizontalBlock)) {
                return NekoColors.getStoneColorOrLightGray(7);
            }
            return NekoColors.getStoneColorOrLightGray((Integer)state.m_61143_((Property)DyeableHorizontalBlock.COLOR));
        }, new Block[]{(Block)ModBlocks.WINDOW_SILL.get(), (Block)ModBlocks.WINDOW_TOP.get(), (Block)ModBlocks.WINDOW_FRAME.get()});
        event.register((state, view, pos, tintIndex) -> {
            if (view == null || pos == null || !(state.m_60734_() instanceof HalfTimberBlock)) {
                return NekoColors.getWoodenColorOrBrown(2);
            }
            return tintIndex == 0 ? NekoColors.getWoodenColorOrBrown((Integer)state.m_61143_((Property)HalfTimberBlock.COLOR0)) : NekoColors.getNekoColorOrWhite((Integer)state.m_61143_((Property)HalfTimberBlock.COLOR1));
        }, new Block[]{(Block)ModBlocks.HALF_TIMBER_P0.get(), (Block)ModBlocks.HALF_TIMBER_P1.get(), (Block)ModBlocks.HALF_TIMBER_P2.get(), (Block)ModBlocks.HALF_TIMBER_P3.get(), (Block)ModBlocks.HALF_TIMBER_P4.get(), (Block)ModBlocks.HALF_TIMBER_P5.get(), (Block)ModBlocks.HALF_TIMBER_P6.get(), (Block)ModBlocks.HALF_TIMBER_P7.get(), (Block)ModBlocks.HALF_TIMBER_P8.get(), (Block)ModBlocks.HALF_TIMBER_P9.get()});
        event.register((state, view, pos, tintIndex) -> {
            if (view == null || pos == null || !(state.m_60734_() instanceof HalfTimberPillarBlock)) {
                return tintIndex == 0 ? NekoColors.getWoodenColorOrBrown(2) : NekoColors.getNekoColorOrWhite(14);
            }
            return tintIndex == 0 ? NekoColors.getWoodenColorOrBrown((Integer)state.m_61143_((Property)HalfTimberBlock.COLOR0)) : NekoColors.getNekoColorOrWhite((Integer)state.m_61143_((Property)HalfTimberBlock.COLOR1));
        }, new Block[]{(Block)ModBlocks.HALF_TIMBER_PILLAR_P0.get(), (Block)ModBlocks.HALF_TIMBER_PILLAR_P1.get(), (Block)ModBlocks.HALF_TIMBER_PILLAR_P2.get()});
        event.register((state, view, pos, tintIndex) -> {
            if (view == null || pos == null || !(state.m_60734_() instanceof DyeableBlock)) {
                return tintIndex == 0 ? NekoColors.EnumNekoColor.PURPLE.getColor() : NekoColors.getNekoColorOrWhite(14);
            }
            return tintIndex == 0 ? BiomeColors.m_108804_((BlockAndTintGetter)view, (BlockPos)pos) : NekoColors.getNekoColorOrWhite((Integer)state.m_61143_((Property)DyeableBlock.COLOR));
        }, new Block[]{(Block)ModBlocks.WINDOW_PLANT.get()});
        event.register((state, view, pos, tintIndex) -> {
            if (view == null || pos == null || !(state.m_60734_() instanceof WindowBlock)) {
                return NekoColors.getWoodenColorOrBrown(2);
            }
            return NekoColors.getWoodenColorOrBrown((Integer)state.m_61143_((Property)WindowBlock.COLOR));
        }, new Block[]{(Block)ModBlocks.WINDOW_SIMPLE.get(), (Block)ModBlocks.WINDOW_ARCH.get(), (Block)ModBlocks.WINDOW_CROSS.get(), (Block)ModBlocks.WINDOW_SHADE.get(), (Block)ModBlocks.WINDOW_LANCET.get()});
        event.register((state, view, pos, tintIndex) -> {
            if (view == null || pos == null || !(state.m_60734_() instanceof DyeableDoorBlock)) {
                return NekoColors.getNekoColorOrWhite(14);
            }
            return NekoColors.getNekoColorOrWhite((Integer)state.m_61143_((Property)DyeableDoorBlock.COLOR));
        }, new Block[]{(Block)ModBlocks.DOOR_1.get(), (Block)ModBlocks.DOOR_2.get(), (Block)ModBlocks.DOOR_3.get(), (Block)ModBlocks.DOOR_TALL_1.get(), (Block)ModBlocks.DOOR_TALL_2.get(), (Block)ModBlocks.DOOR_TALL_3.get()});
        LOGGER.info("Block Colors Registered.");
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> NekoColors.getStoneFromNeko(DyeableBlockItem.getColor(stack)).getColor(), new ItemLike[]{((Block)ModBlocks.STONE_BASE_BOTTOM.get()).m_5456_(), ((Block)ModBlocks.STONE_FRAME_BOTTOM.get()).m_5456_(), ((Block)ModBlocks.STONE_PILLAR_BOTTOM.get()).m_5456_(), ((Block)ModBlocks.STONE_BASE.get()).m_5456_(), ((Block)ModBlocks.STONE_FRAME.get()).m_5456_(), ((Block)ModBlocks.STONE_PILLAR.get()).m_5456_(), ((Block)ModBlocks.STONE_DORIC.get()).m_5456_(), ((Block)ModBlocks.STONE_IONIC.get()).m_5456_(), ((Block)ModBlocks.STONE_CORINTHIAN.get()).m_5456_(), ((Block)ModBlocks.WINDOW_SILL.get()).m_5456_(), ((Block)ModBlocks.WINDOW_TOP.get()).m_5456_(), ((Block)ModBlocks.WINDOW_FRAME.get()).m_5456_(), ((Block)ModBlocks.STONE_LAYERED.get()).m_5456_(), ((Block)ModBlocks.STONE_POT.get()).m_5456_(), ((Block)ModBlocks.STONE_PLANTER.get()).m_5456_()});
        event.register((stack, tintIndex) -> NekoColors.getStoneFromNeko(DyeableBlockItem.getColor(stack)).getColor(), new ItemLike[]{((Block)ModBlocks.CANDLE_HOLDER_IRON.get()).m_5456_(), ((Block)ModBlocks.CANDLE_HOLDER_GOLD.get()).m_5456_(), ((Block)ModBlocks.CANDLE_HOLDER_QUARTZ.get()).m_5456_()});
        event.register((stack, tintIndex) -> {
            switch (tintIndex) {
                default: {
                    return FoliageColor.m_46113_();
                }
                case 1: 
            }
            return DyeableBlockItem.getColor(stack).getColor();
        }, new ItemLike[]{((Block)ModBlocks.WINDOW_PLANT.get()).m_5456_()});
        event.register((stack, tintIndex) -> DyeableWoodenBlockItem.getColor(stack).getColor(), new ItemLike[]{((Block)ModBlocks.WINDOW_SIMPLE.get()).m_5456_(), ((Block)ModBlocks.WINDOW_ARCH.get()).m_5456_(), ((Block)ModBlocks.WINDOW_CROSS.get()).m_5456_(), ((Block)ModBlocks.WINDOW_SHADE.get()).m_5456_(), ((Block)ModBlocks.WINDOW_LANCET.get()).m_5456_(), ((Block)ModBlocks.EASEL_MENU.get()).m_5456_(), ((Block)ModBlocks.EASEL_MENU_WHITE.get()).m_5456_(), ((Block)ModBlocks.GLASS_TABLE.get()).m_5456_(), ((Block)ModBlocks.GLASS_ROUND_TABLE.get()).m_5456_(), ((Block)ModBlocks.CUPBOARD.get()).m_5456_(), ((Block)ModBlocks.SHELF.get()).m_5456_(), ((Block)ModBlocks.WALL_SHELF.get()).m_5456_(), (ItemLike)ModBlocks.BENCH.get(), ((Block)ModBlocks.ARM_CHAIR.get()).m_5456_(), ((Block)ModBlocks.DRAWER.get()).m_5456_(), ((Block)ModBlocks.CABINET.get()).m_5456_(), ((Block)ModBlocks.DRAWER_CHEST.get()).m_5456_()});
        event.register((stack, tintIndex) -> {
            switch (tintIndex) {
                default: {
                    return HalfTimberBlockItem.getColor0(stack).getColor();
                }
                case 1: 
            }
            return HalfTimberBlockItem.getColor1(stack).getColor();
        }, new ItemLike[]{((Block)ModBlocks.HALF_TIMBER_P0.get()).m_5456_(), ((Block)ModBlocks.HALF_TIMBER_P1.get()).m_5456_(), ((Block)ModBlocks.HALF_TIMBER_P2.get()).m_5456_(), ((Block)ModBlocks.HALF_TIMBER_P3.get()).m_5456_(), ((Block)ModBlocks.HALF_TIMBER_P4.get()).m_5456_(), ((Block)ModBlocks.HALF_TIMBER_P5.get()).m_5456_(), ((Block)ModBlocks.HALF_TIMBER_P6.get()).m_5456_(), ((Block)ModBlocks.HALF_TIMBER_P7.get()).m_5456_(), ((Block)ModBlocks.HALF_TIMBER_P8.get()).m_5456_(), ((Block)ModBlocks.HALF_TIMBER_P9.get()).m_5456_(), ((Block)ModBlocks.HALF_TIMBER_PILLAR_P0.get()).m_5456_(), ((Block)ModBlocks.HALF_TIMBER_PILLAR_P1.get()).m_5456_(), ((Block)ModBlocks.HALF_TIMBER_PILLAR_P2.get()).m_5456_()});
        LOGGER.info("Item Colors Registered.");
    }

    private static ModelLayerLocation createLocation(String name, String type) {
        return new ModelLayerLocation(new ResourceLocation("nekoration", name), type);
    }

    @SubscribeEvent
    public static void RegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(WALLPAPER, WallPaperRenderer::createBodyLayer);
    }

    @Nullable
    public static ShaderInstance getRendertypeCatPortalShader() {
        return rendertypeCatPortalShader;
    }

    @SubscribeEvent
    public static void RegisterShaders(RegisterShadersEvent event) {
        ResourceManager manager = event.getResourceManager();
        try {
            event.registerShader(new ShaderInstance((ResourceProvider)manager, "nekoration:rendertype_cat_portal", DefaultVertexFormat.f_85814_), inst -> {
                rendertypeCatPortalShader = inst;
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class BlockListsExport {
        public final HashSet<String> no_occlusion = new HashSet();
        public final HashSet<String> no_collision = new HashSet();
        public final HashSet<String> water_blocks = new HashSet();
        public final HashSet<String> always_fulls = new HashSet();

        private BlockListsExport() {
        }
    }
}

