/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.blocks.frames;

import com.devbobcorn.nekoration.blocks.DyeableHorizontalBlock;
import com.devbobcorn.nekoration.blocks.DyeableHorizontalConnectBlock;
import com.devbobcorn.nekoration.blocks.WindowBlock;
import com.devbobcorn.nekoration.blocks.frames.DyeableWindowSillBlock;
import com.devbobcorn.nekoration.blocks.frames.DyeableWindowTopBlock;
import com.devbobcorn.nekoration.blocks.states.FramePart;
import com.devbobcorn.nekoration.blocks.states.HorizontalConnection;
import com.devbobcorn.nekoration.blocks.states.ModStateProperties;
import com.devbobcorn.nekoration.common.VanillaCompat;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.Tags;

public class DyeableWindowFrameBlock
extends DyeableHorizontalBlock {
    protected static Double thickness = 6.0;
    private static final Map<Direction, VoxelShape> AABBs = DyeableWindowFrameBlock.getAABBs(4.0);
    public static final IntegerProperty COLOR = BlockStateProperties.f_61422_;
    public static final EnumProperty<FramePart> PART = ModStateProperties.FRAME_PART;
    public static final BooleanProperty LEFT = ModStateProperties.LEFT;
    public static final BooleanProperty RIGHT = ModStateProperties.RIGHT;
    public final boolean connectOthers;

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> s) {
        s.m_61104_(new Property[]{COLOR, FACING, PART, LEFT, RIGHT});
    }

    public DyeableWindowFrameBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.connectOthers = false;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)COLOR, (Comparable)Integer.valueOf(14)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return AABBs.get(state.m_61143_((Property)FACING));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (world.f_46443_) {
            return VanillaCompat.COLOR_ITEMS.containsKey(itemStack.m_41720_()) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (VanillaCompat.COLOR_ITEMS.containsKey(itemStack.m_41720_())) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)COLOR, (Comparable)VanillaCompat.COLOR_ITEMS.get(itemStack.m_41720_())), 3);
            return InteractionResult.CONSUME;
        }
        if (itemStack.m_41720_() instanceof AxeItem) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            world.m_7731_(pos, (BlockState)state.m_61122_(PART), 3);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private boolean checkWindowBlock(BlockState state) {
        return state.m_60767_() == Material.f_76296_ || state.m_60734_() instanceof WindowBlock || state.m_204336_(Tags.Blocks.GLASS) || state.m_204336_(Tags.Blocks.GLASS_PANES);
    }

    private boolean checkFrameBlock(BlockState state) {
        return state.m_60734_() instanceof DyeableWindowFrameBlock || state.m_60734_() instanceof DyeableWindowSillBlock || state.m_60734_() instanceof DyeableWindowTopBlock;
    }

    private boolean checkPart(BlockState state, FramePart part) {
        if (part == FramePart.BOTTOM && state.m_60734_() instanceof DyeableWindowSillBlock) {
            return true;
        }
        if (part == FramePart.TOP && state.m_60734_() instanceof DyeableWindowTopBlock) {
            return true;
        }
        if (!(state.m_60734_() instanceof DyeableWindowFrameBlock)) {
            return false;
        }
        return state.m_61143_(PART) == part;
    }

    private FramePart getPart(BlockState state) {
        if (state.m_60734_() instanceof DyeableWindowSillBlock) {
            return FramePart.BOTTOM;
        }
        if (state.m_60734_() instanceof DyeableWindowTopBlock) {
            return FramePart.TOP;
        }
        if (!(state.m_60734_() instanceof DyeableWindowFrameBlock)) {
            return FramePart.MIDDLE;
        }
        return (FramePart)((Object)state.m_61143_(PART));
    }

    private boolean getLeft(BlockState state) {
        if (state.m_60734_() instanceof DyeableHorizontalConnectBlock) {
            HorizontalConnection its = (HorizontalConnection)((Object)state.m_61143_(DyeableHorizontalConnectBlock.CONNECTION));
            return its == HorizontalConnection.S0 || its == HorizontalConnection.D0 || its == HorizontalConnection.T0;
        }
        if (state.m_60734_() instanceof DyeableWindowFrameBlock) {
            return (Boolean)state.m_61143_((Property)LEFT);
        }
        return false;
    }

    private boolean getRight(BlockState state) {
        if (state.m_60734_() instanceof DyeableHorizontalConnectBlock) {
            HorizontalConnection its = (HorizontalConnection)((Object)state.m_61143_(DyeableHorizontalConnectBlock.CONNECTION));
            return its == HorizontalConnection.S0 || its == HorizontalConnection.D1 || its == HorizontalConnection.T2;
        }
        if (state.m_60734_() instanceof DyeableWindowFrameBlock) {
            return (Boolean)state.m_61143_((Property)RIGHT);
        }
        return false;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos pos2;
        Direction dir = ctx.m_8125_().m_122424_();
        Level world = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        BlockPos blockPosL = this.getLeftBlock(blockPos, dir);
        BlockPos blockPosR = this.getRightBlock(blockPos, dir);
        BlockPos blockPosU = this.getUpBlock(blockPos);
        BlockPos blockPosD = this.getDownBlock(blockPos);
        BlockState stateL = world.m_8055_(blockPosL);
        BlockState stateR = world.m_8055_(blockPosR);
        BlockState stateU = world.m_8055_(blockPosU);
        BlockState stateD = world.m_8055_(blockPosD);
        boolean l = this.checkFrameBlock(stateL);
        boolean r = this.checkFrameBlock(stateR);
        boolean u = this.checkFrameBlock(stateU);
        boolean d = this.checkFrameBlock(stateD);
        boolean resl = true;
        boolean resr = false;
        FramePart myPart = !u ? (!d ? (l && !this.checkPart(stateL, FramePart.MIDDLE) ? this.getPart(stateL) : (r && !this.checkPart(stateR, FramePart.MIDDLE) ? this.getPart(stateR) : (this.checkWindowBlock(world.m_8055_((pos2 = this.getFurtherBlock(blockPos, dir)).m_7494_())) ? FramePart.BOTTOM : FramePart.TOP))) : (this.checkPart(stateD, FramePart.TOP) ? FramePart.BOTTOM : FramePart.TOP)) : (this.checkPart(stateU, FramePart.BOTTOM) ? FramePart.TOP : (!d ? FramePart.BOTTOM : FramePart.MIDDLE));
        if (r && l) {
            if (this.checkPart(stateU, FramePart.MIDDLE) || this.checkPart(stateD, FramePart.MIDDLE)) {
                resr = true;
                resl = true;
            } else {
                resr = false;
                resl = false;
            }
        } else if (l) {
            resr = true;
            resl = false;
        } else if (r) {
            resl = true;
            resr = false;
        } else if (u) {
            resl = this.getLeft(stateU);
            resr = this.getRight(stateU);
        } else if (d) {
            resl = this.getLeft(stateD);
            resr = this.getRight(stateD);
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(PART, (Comparable)((Object)myPart))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(resl))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(resr));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        BlockPos pos2;
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        if (direction == dir || direction == dir.m_122424_()) {
            return state;
        }
        BlockPos blockPosL = this.getLeftBlock(pos, dir);
        BlockPos blockPosR = this.getRightBlock(pos, dir);
        BlockPos blockPosU = this.getUpBlock(pos);
        BlockPos blockPosD = this.getDownBlock(pos);
        BlockState stateL = world.m_8055_(blockPosL);
        BlockState stateR = world.m_8055_(blockPosR);
        BlockState stateU = world.m_8055_(blockPosU);
        BlockState stateD = world.m_8055_(blockPosD);
        if (blockPosL.compareTo((Vec3i)posFrom) == 0) {
            stateL = newState;
        }
        if (blockPosR.compareTo((Vec3i)posFrom) == 0) {
            stateR = newState;
        }
        if (blockPosU.compareTo((Vec3i)posFrom) == 0) {
            stateU = newState;
        }
        if (blockPosD.compareTo((Vec3i)posFrom) == 0) {
            stateD = newState;
        }
        boolean l = this.checkFrameBlock(stateL);
        boolean r = this.checkFrameBlock(stateR);
        boolean u = this.checkFrameBlock(stateU);
        boolean d = this.checkFrameBlock(stateD);
        boolean resl = (Boolean)state.m_61143_((Property)LEFT);
        boolean resr = (Boolean)state.m_61143_((Property)RIGHT);
        FramePart myPart = !u ? (!d ? (l && !this.checkPart(stateL, FramePart.MIDDLE) ? this.getPart(stateL) : (r && !this.checkPart(stateR, FramePart.MIDDLE) ? this.getPart(stateR) : (this.checkWindowBlock(world.m_8055_((pos2 = this.getFurtherBlock(pos, dir)).m_7494_())) ? FramePart.BOTTOM : FramePart.TOP))) : (this.checkPart(stateD, FramePart.TOP) ? FramePart.BOTTOM : FramePart.TOP)) : (this.checkPart(stateU, FramePart.BOTTOM) ? FramePart.TOP : (!d ? FramePart.BOTTOM : FramePart.MIDDLE));
        if (r && l) {
            if (this.checkPart(stateU, FramePart.MIDDLE) || this.checkPart(stateD, FramePart.MIDDLE)) {
                resr = true;
                resl = true;
            } else {
                resr = false;
                resl = false;
            }
        } else if (l) {
            resr = true;
            resl = false;
        } else if (r) {
            resl = true;
            resr = false;
        } else if (u) {
            resl = this.getLeft(stateU);
            resr = this.getRight(stateU);
        } else if (d) {
            resl = this.getLeft(stateD);
            resr = this.getRight(stateD);
        }
        return (BlockState)((BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)myPart))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(resl))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(resr));
    }

    public BlockPos getUpBlock(BlockPos pos) {
        return pos.m_7494_();
    }

    public BlockPos getDownBlock(BlockPos pos) {
        return pos.m_7495_();
    }

    @Override
    public BlockPos getLeftBlock(BlockPos pos, Direction dir) {
        switch (dir) {
            case NORTH: {
                return pos.m_122029_();
            }
            case EAST: {
                return pos.m_122019_();
            }
            case SOUTH: {
                return pos.m_122024_();
            }
        }
        return pos.m_122012_();
    }

    @Override
    public BlockPos getRightBlock(BlockPos pos, Direction dir) {
        switch (dir) {
            case NORTH: {
                return pos.m_122024_();
            }
            case EAST: {
                return pos.m_122012_();
            }
            case SOUTH: {
                return pos.m_122029_();
            }
        }
        return pos.m_122019_();
    }

    public BlockPos getFurtherBlock(BlockPos pos, Direction dir) {
        return pos.m_121955_(dir.m_122424_().m_122436_());
    }

    @Override
    public Direction getLeftDir(Direction selfDir) {
        switch (selfDir) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
        }
        return Direction.NORTH;
    }

    @Override
    public Direction getRightDir(Direction selfDir) {
        switch (selfDir) {
            case NORTH: {
                return Direction.WEST;
            }
            case EAST: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.EAST;
            }
        }
        return Direction.SOUTH;
    }
}

