/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.blocks.entities;

import com.devbobcorn.nekoration.blocks.entities.ModBlockEntityType;
import com.devbobcorn.nekoration.utils.TagTypes;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CustomBlockEntity
extends BlockEntity {
    public Byte dir = 0;
    public int[] offset = new int[]{0, 0, 0};
    public Boolean retint = false;
    public Boolean showHint = false;
    public int[] color = new int[]{255, 255, 255};
    public static BlockState defaultState = Blocks.f_50016_.m_49966_();
    public BlockState displayState = Blocks.f_50016_.m_49966_();

    public CustomBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityType.CUSTOM_TYPE.get(), pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128344_("Dir", this.dir.byteValue());
        tag.m_128385_("Offset", this.offset);
        tag.m_128344_("StateFlag", this.GetStateFlag());
        tag.m_128385_("Color", this.color);
        tag.m_128365_("Display", (Tag)NbtUtils.m_129202_((BlockState)this.displayState));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("Dir", (int)TagTypes.BYTE_NBT_ID)) {
            this.dir = tag.m_128445_("Dir");
        }
        if (tag.m_128425_("Offset", (int)TagTypes.INT_ARRAY_NBT_ID)) {
            this.offset = tag.m_128465_("Offset");
        }
        if (tag.m_128425_("StateFlag", (int)TagTypes.BYTE_NBT_ID)) {
            this.SetStateFlag(tag.m_128445_("StateFlag"));
        }
        if (tag.m_128425_("Color", (int)TagTypes.INT_ARRAY_NBT_ID)) {
            this.color = tag.m_128465_("Color");
        }
        if (tag.m_128425_("Display", (int)TagTypes.COMPOUND_NBT_ID)) {
            CompoundTag dat = tag.m_128469_("Display");
            this.displayState = NbtUtils.m_129241_((CompoundTag)dat);
        }
    }

    private byte GetStateFlag() {
        int retintFlag = this.retint != false ? 1 : 0;
        int showHintFlag = this.showHint != false ? 2 : 0;
        return (byte)(retintFlag | showHintFlag);
    }

    public void SetStateFlag(Byte flag) {
        this.retint = (flag & 1) > 0;
        this.showHint = (flag & 2) > 0;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }
}

