/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.blocks;

import com.devbobcorn.nekoration.blocks.DyeableBlock;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class DyeableHorizontalBlock
extends DyeableBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    protected DyeableHorizontalBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> s) {
        s.m_61104_(new Property[]{COLOR, FACING});
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)super.m_5573_(ctx).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    protected static Map<Direction, VoxelShape> getAABBs(double thickness) {
        return Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)(16.0 - thickness), (double)16.0, (double)16.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)thickness), (Object)Direction.EAST, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)thickness, (double)16.0, (double)16.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)(16.0 - thickness), (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)));
    }

    public BlockPos getLeftBlock(BlockPos pos, Direction dir) {
        switch (dir) {
            case NORTH: {
                return pos.m_122029_();
            }
            case EAST: {
                return pos.m_122019_();
            }
            case SOUTH: {
                return pos.m_122024_();
            }
        }
        return pos.m_122012_();
    }

    public BlockPos getRightBlock(BlockPos pos, Direction dir) {
        switch (dir) {
            case NORTH: {
                return pos.m_122024_();
            }
            case EAST: {
                return pos.m_122012_();
            }
            case SOUTH: {
                return pos.m_122029_();
            }
        }
        return pos.m_122019_();
    }

    public Direction getLeftDir(Direction selfDir) {
        switch (selfDir) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
        }
        return Direction.NORTH;
    }

    public Direction getRightDir(Direction selfDir) {
        switch (selfDir) {
            case NORTH: {
                return Direction.WEST;
            }
            case EAST: {
                return Direction.NORTH;
            }
            case SOUTH: {
                return Direction.EAST;
            }
        }
        return Direction.SOUTH;
    }
}

