/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration.blocks;

import com.devbobcorn.nekoration.NekoColors;
import com.devbobcorn.nekoration.common.VanillaCompat;
import com.devbobcorn.nekoration.items.DyeableBlockItem;
import com.devbobcorn.nekoration.items.DyeableWoodenBlockItem;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class DyeableBlock
extends Block {
    public static final IntegerProperty COLOR = BlockStateProperties.f_61422_;

    public DyeableBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)COLOR, (Comparable)Integer.valueOf(14)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> s) {
        s.m_61104_(new Property[]{COLOR});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (world.f_46443_) {
            return VanillaCompat.COLOR_ITEMS.containsKey(itemStack.m_41720_()) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (VanillaCompat.COLOR_ITEMS.containsKey(itemStack.m_41720_())) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)COLOR, (Comparable)VanillaCompat.COLOR_ITEMS.get(itemStack.m_41720_())), 3);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        ItemStack stack = ctx.m_43722_();
        if (stack.m_41720_() instanceof DyeableBlockItem) {
            return (BlockState)this.m_49966_().m_61124_((Property)COLOR, (Comparable)Integer.valueOf(DyeableBlockItem.getColor(stack).getNBTId()));
        }
        if (stack.m_41720_() instanceof DyeableWoodenBlockItem) {
            return (BlockState)this.m_49966_().m_61124_((Property)COLOR, (Comparable)Integer.valueOf(DyeableWoodenBlockItem.getColor(stack).getNBTId()));
        }
        return this.m_49966_();
    }

    @Nonnull
    public ItemStack getCloneItemStack(@Nonnull BlockState state, HitResult target, @Nonnull BlockGetter world, @Nonnull BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this.m_5456_());
        DyeableBlockItem.setColor(stack, NekoColors.EnumNekoColor.getColorEnumFromID(((Integer)state.m_61143_((Property)COLOR)).byteValue()));
        return stack;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        ItemStack stack = new ItemStack((ItemLike)this.m_5456_());
        DyeableBlockItem.setColor(stack, NekoColors.EnumNekoColor.getColorEnumFromID(((Integer)state.m_61143_((Property)COLOR)).byteValue()));
        return Collections.singletonList(stack);
    }
}

