/*
 * Decompiled with CFR 0.152.
 */
package com.devbobcorn.nekoration;

import com.mojang.math.Vector3d;
import java.awt.Color;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;

public class NekoColors {
    public static int getBlockColorAt(int value, int min, int max, int minColor, int maxColor) {
        if (value >= max) {
            return maxColor;
        }
        if (value <= min) {
            return minColor;
        }
        double frac = ((double)value - (double)min) / ((double)max - (double)min);
        return NekoColors.getRGBColorBetween(frac, minColor, maxColor);
    }

    public static int getItemColor(ItemStack stack, int lc, int rc) {
        double frac = (double)stack.m_41613_() / (double)stack.m_41741_();
        return NekoColors.getRGBColorBetween(frac, lc, rc);
    }

    public static final Color getRGBColor(Vec3i vec) {
        return new Color(Math.min(Math.max(vec.m_123341_(), 0), 255), Math.min(Math.max(vec.m_123342_(), 0), 255), Math.min(Math.max(vec.m_123343_(), 0), 255));
    }

    public static final Color getRGBColor(Vector3d vec) {
        return new Color(Math.min(Math.max((int)vec.f_86214_, 0), 255), Math.min(Math.max((int)vec.f_86215_, 0), 255), Math.min(Math.max((int)vec.f_86216_, 0), 255));
    }

    public static Color getRGBColor(double col) {
        int col1 = (int)col;
        return new Color((col1 & 0xFF0000) >> 16, (col1 & 0xFF00) >> 8, col1 & 0xFF);
    }

    public static Color getRGBColor(int col) {
        return new Color((col & 0xFF0000) >> 16, (col & 0xFF00) >> 8, col & 0xFF);
    }

    public static int[] getRGBArray(int col) {
        int[] arr = new int[]{(col & 0xFF0000) >> 16, (col & 0xFF00) >> 8, col & 0xFF};
        return arr;
    }

    public static int getRGBColorBetween(double frac, int lc, int rc) {
        int red1 = (lc & 0xFF0000) >> 16;
        int green1 = (lc & 0xFF00) >> 8;
        int blue1 = lc & 0xFF;
        int red2 = (rc & 0xFF0000) >> 16;
        int green2 = (rc & 0xFF00) >> 8;
        int blue2 = rc & 0xFF;
        int red3 = (int)Mth.m_14139_((double)frac, (double)red1, (double)red2);
        int green3 = (int)Mth.m_14139_((double)frac, (double)green1, (double)green2);
        int blue3 = (int)Mth.m_14139_((double)frac, (double)blue1, (double)blue2);
        return (red3 << 16) + (green3 << 8) + blue3;
    }

    public static Color getRGBColorBetween(double frac, Color lc, Color rc) {
        return new Color((int)Mth.m_14139_((double)frac, (double)lc.getRed(), (double)rc.getRed()), (int)Mth.m_14139_((double)frac, (double)lc.getGreen(), (double)rc.getGreen()), (int)Mth.m_14139_((double)frac, (double)lc.getBlue(), (double)rc.getBlue()));
    }

    public static int getRed(int c) {
        return (c & 0xFF0000) >> 16;
    }

    public static int getGreen(int c) {
        return (c & 0xFF00) >> 8;
    }

    public static int getBlue(int c) {
        return c & 0xFF;
    }

    public static float getRedf(int c) {
        return (float)((c & 0xFF0000) >> 16) / 255.0f;
    }

    public static float getGreenf(int c) {
        return (float)((c & 0xFF00) >> 8) / 255.0f;
    }

    public static float getBluef(int c) {
        return (float)(c & 0xFF) / 255.0f;
    }

    public static EnumStoneColor getStoneFromNeko(EnumNekoColor col) {
        return EnumStoneColor.getColorEnumFromID(col.nbtID);
    }

    public static int getNekoColorOrWhite(int id) {
        return EnumNekoColor.getColorValueFromID((byte)id);
    }

    public static int getStoneColorOrLightGray(int id) {
        return EnumStoneColor.getColorValueFromID((byte)id);
    }

    public static int getWoodenColorOrBrown(int id) {
        return EnumWoodenColor.getColorValueFromID((byte)id);
    }

    public static enum EnumNekoColor implements StringRepresentable
    {
        BLACK(0, "black", 0x5C5C5C),
        BLUE(1, "blue", 2658815),
        BROWN(2, "brown", 6763520),
        CYAN(3, "cyan", 9757439),
        GRAY(4, "gray", 0x9F9F9F),
        GREEN(5, "green", 3388748),
        LIGHT_BLUE(6, "light_blue", 7711487),
        LIGHT_GRAY(7, "light_gray", 0xBEBEBE),
        LIME(8, "lime", 8060815),
        MAGENTA(9, "magenta", 16348927),
        ORANGE(10, "orange", 0xFF7700),
        PINK(11, "pink", 16753632),
        PURPLE(12, "purple", 12345855),
        RED(13, "red", 14696255),
        WHITE(14, "white", 0xFFFFFF),
        YELLOW(15, "yellow", 16762890);

        private final byte nbtID;
        private final String name;
        private final int color;

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        public int getColor() {
            return this.color;
        }

        public int getNBTId() {
            return this.nbtID;
        }

        public static EnumNekoColor fromNBT(CompoundTag compoundNBT, String tagname) {
            byte flavorID = 0;
            if (compoundNBT != null && compoundNBT.m_128441_(tagname)) {
                flavorID = compoundNBT.m_128445_(tagname);
            }
            EnumNekoColor color = EnumNekoColor.getColorEnumFromID(flavorID);
            return color;
        }

        public void putIntoNBT(CompoundTag compoundNBT, String tagname) {
            compoundNBT.m_128344_(tagname, this.nbtID);
        }

        private EnumNekoColor(byte i_NBT_ID, String i_name, int i_color) {
            this.nbtID = i_NBT_ID;
            this.name = i_name;
            this.color = i_color;
        }

        public static EnumNekoColor getColorEnumFromID(byte ID) {
            for (EnumNekoColor c : EnumNekoColor.values()) {
                if (c.nbtID != ID) continue;
                return c;
            }
            return LIGHT_GRAY;
        }

        public static int getColorValueFromID(byte ID) {
            for (EnumNekoColor c : EnumNekoColor.values()) {
                if (c.nbtID != ID) continue;
                return c.color;
            }
            return EnumNekoColor.LIGHT_GRAY.color;
        }

        public float getPropertyOverrideValue() {
            return this.nbtID;
        }
    }

    public static enum EnumStoneColor implements StringRepresentable
    {
        BLACK(0, "black", 0x5C5C5C),
        BLUE(1, "blue", 5544677),
        BROWN(2, "brown", 10713188),
        CYAN(3, "cyan", 9360109),
        GRAY(4, "gray", 0x9F9F9F),
        GREEN(5, "green", 5287519),
        LIGHT_BLUE(6, "light_blue", 8302335),
        LIGHT_GRAY(7, "light_gray", 0xBEBEBE),
        LIME(8, "lime", 9300374),
        MAGENTA(9, "magenta", 15044074),
        ORANGE(10, "orange", 15440229),
        PINK(11, "pink", 15178445),
        PURPLE(12, "purple", 11632855),
        RED(13, "red", 14766674),
        WHITE(14, "white", 16709868),
        YELLOW(15, "yellow", 15847291);

        private final byte nbtID;
        private final String name;
        private final int color;

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        public int getColor() {
            return this.color;
        }

        public int getNBTId() {
            return this.nbtID;
        }

        private EnumStoneColor(byte i_NBT_ID, String i_name, int i_color) {
            this.nbtID = i_NBT_ID;
            this.name = i_name;
            this.color = i_color;
        }

        public static EnumStoneColor getColorEnumFromID(byte ID) {
            for (EnumStoneColor c : EnumStoneColor.values()) {
                if (c.nbtID != ID) continue;
                return c;
            }
            return LIGHT_GRAY;
        }

        public static int getColorValueFromID(byte ID) {
            for (EnumStoneColor c : EnumStoneColor.values()) {
                if (c.nbtID != ID) continue;
                return c.color;
            }
            return EnumStoneColor.LIGHT_GRAY.color;
        }

        public float getPropertyOverrideValue() {
            return this.nbtID;
        }
    }

    public static enum EnumWoodenColor implements StringRepresentable
    {
        BLACK(0, "black", 6044699),
        BLUE(1, "blue", 4481412),
        BROWN(2, "brown", 8938817),
        CYAN(3, "cyan", 3709593),
        GRAY(4, "gray", 11765092),
        GREEN(5, "green", 1546544),
        LIGHT_BLUE(6, "light_blue", 5075376),
        LIGHT_GRAY(7, "light_gray", 0xB9955B),
        LIME(8, "lime", 10464641),
        MAGENTA(9, "magenta", 8860776),
        ORANGE(10, "orange", 11822394),
        PINK(11, "pink", 10111557),
        PURPLE(12, "purple", 8087692),
        RED(13, "red", 10233125),
        WHITE(14, "white", 15259289),
        YELLOW(15, "yellow", 13472068);

        private final byte nbtID;
        private final String name;
        private final int color;

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        public int getColor() {
            return this.color;
        }

        public int getNBTId() {
            return this.nbtID;
        }

        public static EnumWoodenColor fromNBT(CompoundTag compoundNBT, String tagname) {
            byte flavorID = 0;
            if (compoundNBT != null && compoundNBT.m_128441_(tagname)) {
                flavorID = compoundNBT.m_128445_(tagname);
            }
            EnumWoodenColor color = EnumWoodenColor.getColorEnumFromID(flavorID);
            return color;
        }

        public void putIntoNBT(CompoundTag compoundNBT, String tagname) {
            compoundNBT.m_128344_(tagname, this.nbtID);
        }

        private EnumWoodenColor(byte i_NBT_ID, String i_name, int i_color) {
            this.nbtID = i_NBT_ID;
            this.name = i_name;
            this.color = i_color;
        }

        public static EnumWoodenColor getColorEnumFromID(byte ID) {
            for (EnumWoodenColor c : EnumWoodenColor.values()) {
                if (c.nbtID != ID) continue;
                return c;
            }
            return BROWN;
        }

        public static int getColorValueFromID(byte ID) {
            for (EnumWoodenColor c : EnumWoodenColor.values()) {
                if (c.nbtID != ID) continue;
                return c.color;
            }
            return EnumWoodenColor.BROWN.color;
        }

        public float getPropertyOverrideValue() {
            return this.nbtID;
        }
    }
}

