/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.util;

import javax.annotation.Nullable;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;

public class BlockUtil {
    public static boolean canSurvive(Block instance, WorldAccess world, BlockPos pos, Direction facing, int part, int totalWidthHeight) {
        BlockPos posRightOrUp;
        BlockState blockRightOrUp;
        BlockPos posLeftOrDown;
        BlockState blockLeftOrDown;
        boolean checkLeftOrBottom = part != 0;
        boolean checkRightOrTop = part != totalWidthHeight - 1;
        boolean canSurvive = true;
        if (checkLeftOrBottom && !(blockLeftOrDown = world.getBlockState(posLeftOrDown = pos.offset(facing.getOpposite()))).getBlock().equals((Object)instance)) {
            return false;
        }
        if (checkRightOrTop && !(blockRightOrUp = world.getBlockState(posRightOrUp = pos.offset(facing))).getBlock().equals((Object)instance)) {
            return false;
        }
        return canSurvive;
    }

    public static boolean isReplacable(World world, BlockPos startPos, Direction direction, ItemPlacementContext ctx, int distance) {
        for (int i = 0; i < distance; ++i) {
            BlockPos posUp = startPos.offset(direction, i);
            BlockState blockState = world.getBlockState(posUp);
            if (blockState.canReplace(ctx)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static BlockEntity getBlockEntityOrNull(World world, BlockPos pos) {
        if (!world.isChunkLoaded(BlockUtil.getChunkCoords(pos.getX()), BlockUtil.getChunkCoords(pos.getZ()))) {
            return null;
        }
        return world.getBlockEntity(pos);
    }

    @Nullable
    public static BlockState getBlockState(World world, BlockPos pos) {
        if (!world.isChunkLoaded(BlockUtil.getChunkCoords(pos.getX()), BlockUtil.getChunkCoords(pos.getZ()))) {
            return null;
        }
        return world.getBlockState(pos);
    }

    private static int getChunkCoords(int pos) {
        return pos >> 4;
    }
}

