/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.keymapping;

import java.util.HashMap;
import java.util.Map;

public class DefaultButtonsKeyMapping {
    private final Map<String, ButtonArea> buttonMap = new HashMap<String, ButtonArea>();

    public void registerButton(String buttonName, float[] location, float[] dimension) {
        if (!this.buttonMap.containsKey(buttonName)) {
            this.buttonMap.put(buttonName, new ButtonArea(location, dimension));
        }
    }

    public void removeButton(String buttonName) {
        this.buttonMap.remove(buttonName);
    }

    public String mapping(double x, double hitY) {
        for (Map.Entry<String, ButtonArea> entry : this.buttonMap.entrySet()) {
            ButtonArea area = entry.getValue();
            boolean hit = x < -((double)area.location[0] - 0.5) && x > -((double)area.location[0] - 0.5) - (double)area.dimension[0] && hitY > (double)area.location[1] && hitY < (double)(area.location[1] + area.dimension[1]);
            if (!hit) continue;
            return entry.getKey();
        }
        return "null";
    }

    public int getButtonCount() {
        return this.buttonMap.size();
    }

    private static class ButtonArea {
        float[] location;
        float[] dimension;

        ButtonArea(float[] location, float[] dimension) {
            this.location = location;
            this.dimension = dimension;
        }
    }
}

