/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.item;

import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.World;
import org.mtr.mod.block.BlockLiftButtons;
import org.mtr.mod.block.BlockLiftPanelBase;
import org.mtr.mod.block.BlockLiftTrackFloor;
import org.mtr.mod.item.ItemBlockClickingBase;
import top.xfunny.mod.ButtonRegistry;
import top.xfunny.mod.LiftFloorRegistry;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.block.base.LiftDestinationDispatchTerminalBase;
import top.xfunny.mod.item.LinkerValidTypes;

public class YteLiftButtonsLinker
extends ItemBlockClickingBase {
    private final boolean isConnector;

    public YteLiftButtonsLinker(boolean isConnector, ItemSettings itemSettings) {
        super(itemSettings.maxCount(1));
        this.isConnector = isConnector;
    }

    private static void connect(World world, BlockPos blockPos1, BlockPos blockPos2, boolean isAdd) {
        BlockEntity blockEntity1 = world.getBlockEntity(blockPos1);
        BlockEntity blockEntity2 = world.getBlockEntity(blockPos2);
        if (blockEntity1 != null && blockEntity2 != null) {
            if (blockEntity2.data instanceof BlockLiftTrackFloor.BlockEntity) {
                if (blockEntity1.data instanceof LiftFloorRegistry) {
                    ((LiftFloorRegistry)blockEntity1.data).registerFloor(blockPos1, world, blockPos2, isAdd);
                } else if (blockEntity1.data instanceof BlockLiftButtons.BlockEntity) {
                    ((BlockLiftButtons.BlockEntity)blockEntity1.data).registerFloor(blockPos2, isAdd);
                } else if (blockEntity1.data instanceof BlockLiftPanelBase.BlockEntityBase) {
                    ((BlockLiftPanelBase.BlockEntityBase)blockEntity1.data).registerFloor(world, blockPos2, isAdd);
                }
            } else if ((blockEntity2.data instanceof LiftButtonsBase.BlockEntityBase || blockEntity2.data instanceof LiftDestinationDispatchTerminalBase.BlockEntityBase) && blockEntity1.data instanceof ButtonRegistry) {
                ((ButtonRegistry)blockEntity2.data).registerButton(world, blockPos1, isAdd);
                ((ButtonRegistry)blockEntity1.data).registerButton(world, blockPos2, isAdd);
            }
        }
    }

    protected void onStartClick(ItemUsageContext context, CompoundTag compoundTag) {
    }

    protected void onEndClick(ItemUsageContext context, BlockPos posEnd, CompoundTag compoundTag) {
        World world = context.getWorld();
        BlockPos posStart = context.getBlockPos();
        YteLiftButtonsLinker.connect(world, posStart, posEnd, this.isConnector);
        YteLiftButtonsLinker.connect(world, posEnd, posStart, this.isConnector);
    }

    private boolean isValidType(Object data) {
        return LinkerValidTypes.VALID_TYPES.contains(data.getClass());
    }

    protected boolean clickCondition(ItemUsageContext context) {
        Block block = context.getWorld().getBlockState(context.getBlockPos()).getBlock();
        return this.isValidType(block.data);
    }
}

