/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.Block;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.ItemSettings;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.ItemUsageContext;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.TooltipContext;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.ItemExtension;
import org.mtr.mod.generated.lang.TranslationProvider;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.block.base.LiftDestinationDispatchTerminalBase;
import top.xfunny.mod.block.base.LiftPanelBase;

public abstract class YTEItemBlockClickingBase
extends ItemExtension {
    public static final String TAG_POS = "pos";
    public static final String TAG_SECOND_POS = "secondPos";

    public YTEItemBlockClickingBase(ItemSettings itemSettings) {
        super(itemSettings);
    }

    @Nonnull
    public ActionResult useOnBlock2(ItemUsageContext context) {
        if (!context.getWorld().isClient()) {
            if (this.clickCondition(context)) {
                CompoundTag compoundTag = context.getStack().getOrCreateTag();
                if (compoundTag.contains(TAG_SECOND_POS)) {
                    BlockPos posEnd = BlockPos.fromLong((long)compoundTag.getLong(TAG_POS));
                    BlockPos posStart = BlockPos.fromLong((long)compoundTag.getLong(TAG_SECOND_POS));
                    BlockPos posThird = context.getBlockPos();
                    this.onThirdClick(context, posStart, posEnd, posThird, compoundTag);
                    compoundTag.remove(TAG_SECOND_POS);
                    compoundTag.remove(TAG_POS);
                } else if (compoundTag.contains(TAG_POS)) {
                    boolean isBlockStartValid;
                    BlockPos posEnd = BlockPos.fromLong((long)compoundTag.getLong(TAG_POS));
                    BlockPos posStart = context.getBlockPos();
                    World world = context.getWorld();
                    Block blockEnd = world.getBlockState(posEnd).getBlock();
                    Block blockStart = world.getBlockState(posStart).getBlock();
                    boolean isBlockEndValid = blockEnd.data instanceof LiftButtonsBase || blockEnd.data instanceof LiftDestinationDispatchTerminalBase || blockEnd.data instanceof LiftPanelBase;
                    boolean bl = isBlockStartValid = blockStart.data instanceof LiftButtonsBase || blockStart.data instanceof LiftDestinationDispatchTerminalBase || blockStart.data instanceof LiftPanelBase;
                    if (isBlockEndValid) {
                        if (isBlockStartValid) {
                            this.onEndClick(context, posEnd, compoundTag);
                            compoundTag.putLong(TAG_SECOND_POS, posStart.asLong());
                        } else {
                            this.onEndClick(context, posEnd, compoundTag);
                            compoundTag.remove(TAG_POS);
                        }
                    } else {
                        this.onEndClick(context, posEnd, compoundTag);
                        compoundTag.remove(TAG_POS);
                    }
                } else {
                    compoundTag.putLong(TAG_POS, context.getBlockPos().asLong());
                    this.onStartClick(context, compoundTag);
                }
                return ActionResult.SUCCESS;
            }
            return ActionResult.FAIL;
        }
        return super.useOnBlock2(context);
    }

    public void addTooltips(ItemStack stack, @Nullable World world, List<MutableText> tooltip, TooltipContext options) {
        CompoundTag compoundTag = stack.getOrCreateTag();
        long posLong = compoundTag.getLong(TAG_POS);
        if (posLong != 0L) {
            tooltip.add(TranslationProvider.TOOLTIP_MTR_SELECTED_BLOCK.getMutableText(new Object[]{BlockPos.fromLong((long)posLong).toShortString()}).formatted(TextFormatting.GOLD));
        }
    }

    protected abstract void onStartClick(ItemUsageContext var1, CompoundTag var2);

    protected abstract void onEndClick(ItemUsageContext var1, BlockPos var2, CompoundTag var3);

    protected abstract void onThirdClick(ItemUsageContext var1, BlockPos var2, BlockPos var3, BlockPos var4, CompoundTag var5);

    protected abstract boolean clickCondition(ItemUsageContext var1);
}

