/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Config {
    private final Path configFilePath;
    private static final Logger LOGGER = LogManager.getLogger(Config.class);

    public Config(Path configFilePath) {
        this.configFilePath = configFilePath;
    }

    public void readConfig() {
        if (!Files.exists(this.configFilePath, new LinkOption[0])) {
            this.writeConfig();
            this.readConfig();
        } else {
            try {
                JsonObject jsonObject = new JsonParser().parse(String.join((CharSequence)"", Files.readAllLines(this.configFilePath))).getAsJsonObject();
                this.setTempConfigItems(jsonObject);
            }
            catch (Exception e) {
                LOGGER.error("Failed to read config file: " + String.valueOf(this.configFilePath), (Throwable)e);
                this.writeConfig();
            }
        }
    }

    public void writeConfig() {
        try {
            Files.createDirectories(this.configFilePath.getParent(), new FileAttribute[0]);
            Files.write(this.configFilePath, Collections.singleton(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.getTempConfigItems())), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write config file: " + String.valueOf(this.configFilePath), (Throwable)e);
        }
    }

    protected abstract void setTempConfigItems(JsonObject var1);

    protected abstract JsonObject getTempConfigItems();
}

