/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.view;

import java.awt.Font;
import java.util.function.Consumer;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.client.DynamicTextureCache;
import top.xfunny.mod.client.resource.TextureList;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.RenderView;

public class TextView
implements RenderView {
    protected String id;
    protected StoredMatrixTransformations storedMatrixTransformations;
    protected StoredMatrixTransformations storedMatrixTransformations1;
    protected Font font;
    protected int color;
    protected int letterSpacing = 0;
    protected World world;
    protected BlockPos blockPos;
    protected float height;
    protected float width;
    protected int displayTextLength = 2;
    protected float scrollSpeed;
    protected float x;
    protected float y;
    protected float textX;
    protected float textY;
    protected String textureId;
    protected float fontSize;
    protected float gameTick;
    protected String text;
    protected DynamicTextureCache.DynamicResource texture;
    protected float fixedWidth;
    protected float textWidth;
    protected float textHeight;
    protected float marginLeft;
    protected float marginTop;
    protected float marginRight;
    protected float marginBottom;
    protected HorizontalTextAlign horizontalTextAlign = HorizontalTextAlign.RIGHT;
    protected VerticalTextAlign verticalTextAlign = VerticalTextAlign.CENTER;
    protected AdaptMode adaptMode = AdaptMode.ASPECT_FILL;
    protected Gravity gravity;
    protected Consumer<GraphicsHolder> transformation;
    protected Direction facing;
    private QueuedRenderLayer queuedRenderLayer = QueuedRenderLayer.EXTERIOR_TRANSLUCENT;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void render() {
        this.calculateSize();
        this.calculateTextPositionX();
        this.calculateTextPositionY();
        BlockState blockState = this.world.getBlockState(this.blockPos);
        this.facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)DirectionHelper.FACING);
        this.storedMatrixTransformations1 = this.storedMatrixTransformations.copy();
        this.storedMatrixTransformations1.add(graphicsHolder -> {});
        if (this.transformation != null) {
            this.storedMatrixTransformations1.add(this.transformation);
        }
        if (this.text.length() > this.displayTextLength && this.adaptMode == AdaptMode.ASPECT_FILL) {
            float offset1 = this.gameTick * this.scrollSpeed % 1.0f;
            MainRenderer.scheduleRender((Identifier)this.texture.identifier, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                this.storedMatrixTransformations1.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)this.textX, (float)this.textY, (float)this.fixedWidth, (float)this.textHeight, (float)(offset1 + this.fixedWidth / this.textWidth), (float)1.0f, (float)offset1, (float)0.0f, (Direction)Direction.UP, (int)-1, (int)GraphicsHolder.getDefaultLight());
                graphicsHolder.pop();
            });
        } else {
            MainRenderer.scheduleRender((Identifier)this.texture.identifier, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                this.storedMatrixTransformations1.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)this.textX, (float)this.textY, (float)this.textWidth, (float)this.textHeight, (float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (Direction)Direction.UP, (int)-1, (int)GraphicsHolder.getDefaultLight());
                graphicsHolder.pop();
            });
        }
    }

    protected void calculateSize() {
        this.gameTick = InitClient.getGameTick();
        this.texture = TextureList.instance.renderFont(this.textureId, this.text, this.color, this.font, this.fontSize, this.letterSpacing);
        int rawTextWidth = this.texture.width;
        int rawTextHeight = this.texture.height;
        float scale = (float)rawTextHeight / this.height;
        switch (this.adaptMode) {
            case FORCE_FIT_WIDTH: {
                this.fixedWidth = this.width;
                this.textWidth = this.width;
                this.textHeight = (float)rawTextHeight / scale;
                break;
            }
            case ASPECT_FILL: {
                this.textWidth = (float)rawTextWidth / scale;
                this.textHeight = (float)rawTextHeight / scale;
                this.fixedWidth = this.textWidth / (float)this.text.length() * (float)this.displayTextLength;
                break;
            }
            case FIT_WIDTH: {
                float scaleByWidth = (float)rawTextWidth / this.width;
                float scaleByMaxHeight = (float)rawTextHeight / this.height;
                float finalScale = Math.max(scaleByWidth, scaleByMaxHeight);
                this.fixedWidth = this.textWidth = (float)rawTextWidth / finalScale;
                this.textHeight = (float)rawTextHeight / finalScale;
            }
        }
    }

    @Override
    public void setStoredMatrixTransformations(StoredMatrixTransformations storedMatrixTransformations) {
        this.storedMatrixTransformations = storedMatrixTransformations;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setTextAlign(HorizontalTextAlign horizontalTextAlign) {
        this.horizontalTextAlign = horizontalTextAlign;
    }

    public void setTextAlign(HorizontalTextAlign horizontalTextAlign, VerticalTextAlign verticalTextAlign) {
        this.horizontalTextAlign = horizontalTextAlign;
        this.verticalTextAlign = verticalTextAlign;
    }

    public void setLetterSpacing(int letterSpacing) {
        this.letterSpacing = letterSpacing;
    }

    public void setAdaptMode(AdaptMode adaptMode) {
        this.adaptMode = adaptMode;
    }

    public void setQueuedRenderLayer(QueuedRenderLayer queuedRenderLayer) {
        this.queuedRenderLayer = queuedRenderLayer;
    }

    protected void calculateTextPositionX() {
        switch (this.horizontalTextAlign) {
            case LEFT: {
                this.textX = this.x + this.width - (this.text.length() > this.displayTextLength ? (this.displayTextLength != 0 ? this.fixedWidth : this.textWidth) : this.textWidth);
                break;
            }
            case CENTER: {
                this.textX = this.x + this.width / 2.0f - (this.text.length() > this.displayTextLength ? (this.displayTextLength != 0 ? this.fixedWidth : this.textWidth) : this.textWidth) / 2.0f;
                break;
            }
            case RIGHT: {
                this.textX = this.x;
            }
        }
    }

    protected void calculateTextPositionY() {
        switch (this.verticalTextAlign) {
            case TOP: {
                this.textY = this.y + this.height - this.textHeight;
                break;
            }
            case CENTER: {
                this.textY = this.y + this.height / 2.0f - this.textHeight / 2.0f;
                break;
            }
            case BOTTOM: {
                this.textY = this.y;
            }
        }
    }

    @Override
    public void setParentDimensions(float parentWidth, float parentHeight) {
    }

    @Override
    public void calculateLayoutWidth() {
    }

    @Override
    public void calculateLayoutHeight() {
    }

    @Override
    public float[] calculateChildGravityOffset(float childWidth, float childHeight, float[] childMargin, Gravity childGravity) {
        return new float[0];
    }

    @Override
    public Object getParentType() {
        return null;
    }

    @Override
    public void setParentType(Object thisObject) {
    }

    @Override
    public float[] getMargin() {
        return new float[]{this.marginLeft, this.marginTop, this.marginRight, this.marginBottom};
    }

    @Override
    public Gravity getGravity() {
        return this.gravity;
    }

    @Override
    public void setGravity(Gravity gravity) {
        this.gravity = gravity;
    }

    public int getTextLength() {
        return this.text.length();
    }

    @Override
    public void setMargin(float left, float top, float right, float bottom) {
        this.marginLeft = left;
        this.marginTop = top;
        this.marginRight = right;
        this.marginBottom = bottom;
    }

    @Override
    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setDisplayLength(int textSize, float scrollSpeed) {
        this.displayTextLength = textSize;
        this.scrollSpeed = scrollSpeed;
    }

    public void setBasicsAttributes(World world, BlockPos blockPos, Font font, int fontSize, int color) {
        this.world = world;
        this.blockPos = blockPos;
        this.font = font;
        this.fontSize = fontSize;
        this.color = color;
    }

    public void setTextureId(String textureId) {
        this.textureId = textureId;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void addStoredMatrixTransformations(Consumer<GraphicsHolder> transformation) {
        this.transformation = transformation;
    }

    public static enum HorizontalTextAlign {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum VerticalTextAlign {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum AdaptMode {
        FORCE_FIT_WIDTH,
        ASPECT_FILL,
        FIT_WIDTH;

    }
}

