/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.view;

import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.World;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import top.xfunny.mod.client.view.ImageView;
import top.xfunny.mod.util.ClientGetLiftDetails;

public class LiftArrowView
extends ImageView {
    private Lift lift;
    private ArrowType arrowType;
    private boolean needScroll;
    private float scrollSpeed;
    private boolean alwaysOn;

    @Override
    public void render() {
        float gameTick = InitClient.getGameTick();
        ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = ClientGetLiftDetails.getLiftDetails(this.world, this.lift, Init.positionToBlockPos((Position)this.lift.getCurrentFloor().getPosition()));
        LiftDirection liftDirection = (LiftDirection)liftDetails.left();
        float[] uv = this.uv(liftDirection, gameTick);
        this.setUv(uv);
        switch (this.arrowType) {
            case UP: {
                if (!this.alwaysOn && !liftDirection.equals((Object)LiftDirection.UP)) break;
                super.render();
                break;
            }
            case DOWN: {
                if (!this.alwaysOn && !liftDirection.equals((Object)LiftDirection.DOWN)) break;
                super.render();
                break;
            }
            case BOTH: {
                if (!this.alwaysOn && (!liftDirection.equals((Object)LiftDirection.NONE) || this.lift.getDoorValue() == 0.0f)) break;
                super.render();
                break;
            }
            case AUTO: {
                if (!this.alwaysOn && liftDirection.equals((Object)LiftDirection.NONE)) break;
                super.render();
            }
        }
    }

    public void setBasicsAttributes(World world, BlockPos blockPos, Lift lift, ArrowType arrowType) {
        this.world = world;
        this.blockPos = blockPos;
        this.lift = lift;
        this.arrowType = arrowType;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setDefaultColor(int color) {
        this.color = color;
        this.alwaysOn = true;
    }

    private float[] uv(LiftDirection direction, float gameTick) {
        float[] uv = new float[4];
        float uvOffset = gameTick * this.scrollSpeed % 1.0f;
        uv[0] = 0.0f;
        uv[1] = (!direction.equals((Object)LiftDirection.UP) ? 0.0f : 1.0f) + (this.needScroll && !direction.equals((Object)LiftDirection.NONE) ? uvOffset : 0.0f);
        uv[2] = 1.0f;
        uv[3] = (!direction.equals((Object)LiftDirection.UP) ? 1.0f : 0.0f) + (this.needScroll && !direction.equals((Object)LiftDirection.NONE) ? uvOffset : 0.0f);
        return uv;
    }

    public void setAnimationScrolling(boolean needScroll, float scrollSpeed) {
        this.needScroll = needScroll;
        this.scrollSpeed = scrollSpeed;
    }

    public static enum ArrowType {
        UP,
        DOWN,
        BOTH,
        AUTO;

    }
}

