/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.view;

import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.HitResult;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mod.Init;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.render.QueuedRenderLayer;
import top.xfunny.mod.client.view.ImageView;
import top.xfunny.mod.keymapping.DefaultButtonsKeyMapping;
import top.xfunny.mod.util.TransformPositionX;

public class ButtonView
extends ImageView {
    private int hoverColor;
    private int pressedColor;
    private int defaultColor;
    private boolean isFocused;
    private boolean isPressed;
    private boolean isAlwaysOn;
    private DefaultButtonsKeyMapping keyMapping;
    private float[] location = new float[2];
    private float[] dimension = new float[2];
    private float[] uv = new float[]{1.0f, 1.0f, 0.0f, 0.0f};

    public void setBasicsAttributes(World world, BlockPos blockPos, DefaultButtonsKeyMapping keyMapping) {
        this.keyMapping = keyMapping;
        super.setBasicsAttributes(world, blockPos);
    }

    @Override
    public void setBasicsAttributes(World world, BlockPos blockPos) {
        super.setBasicsAttributes(world, blockPos);
    }

    @Override
    public void render() {
        this.location[0] = this.x;
        this.location[1] = this.y;
        this.dimension[0] = this.width;
        this.dimension[1] = this.height;
        HitResult hitResult = MinecraftClient.getInstance().getCrosshairTargetMapped();
        if (hitResult != null && this.keyMapping != null) {
            this.keyMapping.registerButton(this.id, this.location, this.dimension);
            BlockState blockState = this.world.getBlockState(this.blockPos);
            Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)DirectionHelper.FACING);
            Vector3d hitLocation = hitResult.getPos();
            String inButton = this.keyMapping.mapping(TransformPositionX.transform(MathHelper.fractionalPart((double)hitLocation.getXMapped()), MathHelper.fractionalPart((double)hitLocation.getZMapped()), facing), MathHelper.fractionalPart((double)hitLocation.getYMapped()));
            boolean inBlock = Init.newBlockPos((double)hitLocation.getXMapped(), (double)hitLocation.getYMapped(), (double)hitLocation.getZMapped()).equals((Object)this.blockPos);
            boolean bl = this.isFocused = inBlock && inButton.equals(this.id);
        }
        if (this.isFocused || this.isPressed || this.isAlwaysOn) {
            this.setQueuedRenderLayer(QueuedRenderLayer.LIGHT_TRANSLUCENT);
        }
        this.setUv(this.uv);
        this.color = this.isPressed ? this.pressedColor : (this.isFocused ? this.hoverColor : this.defaultColor);
        super.render();
    }

    public void setDefaultColor(int defaultColor, boolean isAlwaysOn) {
        this.defaultColor = defaultColor;
        this.isAlwaysOn = isAlwaysOn;
    }

    public void setDefaultColor(int defaultColor) {
        this.defaultColor = defaultColor;
    }

    public void setHoverColor(int hoverColor) {
        this.hoverColor = hoverColor;
    }

    public void setPressedColor(int pressedColor) {
        this.pressedColor = pressedColor;
    }

    @Override
    public void setFlip(boolean flipVertical, boolean flipHorizontal) {
        if (flipVertical) {
            float tempV = this.uv[0];
            this.uv[0] = this.uv[2];
            this.uv[2] = tempV;
        }
        if (flipHorizontal) {
            float tempU = this.uv[1];
            this.uv[1] = this.uv[3];
            this.uv[3] = tempU;
        }
    }

    public void activate() {
        this.isPressed = true;
    }
}

