/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.screen.widget;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.ClickableWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;
import top.xfunny.mod.client.screen.GuiHelper;
import top.xfunny.mod.client.screen.widget.BaseListItem;
import top.xfunny.mod.client.screen.widget.CategoryItem;
import top.xfunny.mod.client.screen.widget.ContentItem;

public class ListViewWidget
extends ClickableWidgetExtension {
    public static final int ENTRY_PADDING = 5;
    private final List<BaseListItem> displayedEntryList = new ArrayList<BaseListItem>();
    private final List<BaseListItem> entryList = new ArrayList<BaseListItem>();
    private String searchTerm = "";
    public static final int SCROLLBAR_WIDTH = 5;
    protected double currentScroll = 0.0;
    private boolean scrollbarDragging = false;

    public ListViewWidget() {
        super(0, 0, 0, 0);
    }

    public ListViewWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void setXYSize(int x, int y, int width, int height) {
        this.setX2(x);
        this.setY2(y);
        this.setWidth2(width);
        this.setHeightMapped(height);
        this.refreshDisplay();
    }

    public void add(MutableText text, ButtonWidgetExtension widget) {
        this.add(new ContentItem(text, widget));
        this.refreshDisplay();
    }

    public void add(BaseListItem listItem) {
        this.entryList.add(listItem);
        this.refreshDisplay();
    }

    public void addCategory(MutableText text) {
        this.entryList.add(new CategoryItem(text));
        this.refreshDisplay();
    }

    public void clear() {
        this.entryList.clear();
        this.refreshDisplay();
    }

    public void refreshDisplay() {
        this.displayedEntryList.addAll(this.entryList);
        this.entryList.clear();
        this.entryList.addAll(this.displayedEntryList);
        this.displayedEntryList.clear();
        this.updateItemPositions();
        this.setScroll(this.currentScroll);
    }

    private void updateItemPositions() {
        int incY = 0;
        for (BaseListItem listItem : this.entryList) {
            int entryX = this.getX2();
            int entryY = this.getY2() + incY - (int)this.currentScroll;
            listItem.positionChanged(entryX + this.f_93618_ - 5, entryY);
            incY += listItem.height;
        }
    }

    public void render(@NotNull GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        GuiHelper.drawRectangle(new GuiDrawing(graphicsHolder), this.getX2(), this.getY2(), this.f_93618_, this.f_93619_, 0x4C4C4C4C);
        this.renderContent(graphicsHolder, mouseX, mouseY, tickDelta);
        this.renderScrollBar(graphicsHolder, mouseX, mouseY, tickDelta);
    }

    public void renderContent(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        int incY = 0;
        for (BaseListItem listItem : this.entryList) {
            int scrollbarWidth = this.contentOverflowed() ? 5 : 0;
            int listItemWidth = this.f_93618_ - scrollbarWidth;
            int entryX = this.getX2();
            int entryY = this.getY2() + incY - (int)this.currentScroll;
            listItem.draw(graphicsHolder, guiDrawing, entryX, entryY, listItemWidth, this.f_93619_, mouseX, mouseY, true, tickDelta);
            listItem.positionChanged(entryX + listItemWidth - 5, entryY);
            incY += listItem.height;
        }
    }

    public boolean mouseScrolled2(double mouseX, double mouseY, double amount) {
        double oldScroll = this.currentScroll;
        if (this.contentOverflowed()) {
            this.setScroll(oldScroll - (amount *= 26.0));
        }
        return oldScroll != this.currentScroll;
    }

    public boolean mouseClicked2(double mouseX, double mouseY, int button) {
        this.scrollbarDragging = button == 0 && this.isScrollbarHover(mouseX, mouseY);
        return true;
    }

    public void renderScrollBar(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        if (!this.contentOverflowed()) {
            return;
        }
        GuiDrawing guiDrawing = new GuiDrawing(graphicsHolder);
        int entryHeight = this.getContentHeight();
        int visibleHeight = this.getHeight2();
        double scrollbarHeight = (double)visibleHeight * ((double)visibleHeight / (double)entryHeight);
        double bottomOffset = this.currentScroll / (double)(entryHeight - visibleHeight);
        double yOffset = bottomOffset * ((double)visibleHeight - scrollbarHeight);
        GuiHelper.drawRectangle(guiDrawing, this.getX2() + this.getWidth2() - 5, (double)this.getY2() + yOffset, 5.0, scrollbarHeight, this.isScrollbarHover(mouseX, mouseY) ? -3026479 : -6316129);
    }

    protected int getContentHeight() {
        int entryHeight = 0;
        for (BaseListItem listItem : this.entryList) {
            entryHeight += listItem.height;
        }
        return entryHeight;
    }

    protected boolean contentOverflowed() {
        return this.getContentHeight() > this.getHeight2();
    }

    private boolean isScrollbarHover(double mouseX, double mouseY) {
        return mouseX >= (double)(this.getX2() + this.getWidth2() - 5) && mouseY >= (double)this.getY2() && mouseX < (double)(this.getX2() + this.getWidth2()) && mouseY < (double)(this.getY2() + this.getContentHeight());
    }

    public void setScroll(double scroll) {
        int maxScroll = Math.max(0, this.getContentHeight() - this.getHeight2());
        this.currentScroll = MathHelper.clamp((double)scroll, (double)0.0, (double)maxScroll);
    }
}

