/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.screen.widget;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.ResourceManagerHelper;
import top.xfunny.mod.Init;

public class CustomSignsManager {
    private static ObjectArrayList<String> allSigns = new ObjectArrayList();
    private static ObjectArrayList<String> defaultSigns = new ObjectArrayList();
    private static final Set<String> builtinFileNames;
    private static final Set<String> NAFileNames;

    public static void loader() {
        defaultSigns.clear();
        builtinFileNames.clear();
        allSigns.clear();
        ResourceManagerHelper.readAllResources((Identifier)new Identifier("mtr", "mtr_custom_resources.json"), inputStream -> {
            try (InputStreamReader reader = new InputStreamReader((InputStream)inputStream);){
                Gson gson = new Gson();
                JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                JsonArray signsArray = jsonObject.getAsJsonArray("signs");
                for (JsonElement signElement : signsArray) {
                    JsonObject signObject = signElement.getAsJsonObject();
                    String id = signObject.get("id").getAsString();
                    String textureResource = signObject.get("textureResource").getAsString();
                    String fileName = new File(textureResource).getName();
                    if (!id.startsWith("!")) continue;
                    builtinFileNames.add(fileName);
                }
            }
            catch (Exception e) {
                Init.LOGGER.error("Fake MTR", (Throwable)e);
            }
        });
        ResourceManagerHelper.readDirectory((String)"textures/block/sign", (identifier, inputStream) -> {
            try {
                if (identifier.getNamespace().equals("mtr") && identifier.getPath().endsWith(".png")) {
                    String fileName = new File(identifier.getPath()).getName();
                    String substring = fileName.substring(0, fileName.length() - 4);
                    if (builtinFileNames.contains(fileName)) {
                        defaultSigns.add((Object)substring);
                    } else if (!NAFileNames.contains(fileName)) {
                        allSigns.add((Object)substring);
                    }
                }
            }
            catch (Exception e) {
                Init.LOGGER.error("Fake MTR", (Throwable)e);
            }
        });
        defaultSigns = new ObjectArrayList(new LinkedHashSet<String>((Collection<String>)defaultSigns));
        allSigns.addAll(0, defaultSigns);
        allSigns = new ObjectArrayList(new LinkedHashSet<String>((Collection<String>)allSigns));
        Init.LOGGER.info("Found {} Icon Files", (Object)allSigns.size());
    }

    public static ObjectArrayList<String> getSignList() {
        return allSigns;
    }

    public static int getDefaultSignListSize() {
        return defaultSigns.size();
    }

    static {
        HashSet<String> names = new HashSet<String>();
        names.add("");
        builtinFileNames = names;
        NAFileNames = new HashSet<String>();
        Collections.addAll(NAFileNames, "seven_segment.png", "qr_code.png", "lift_arrow.png", "exit_letter_blank.png", "circle.png", "door_not_in_use.png", "gap_small.png", "logo_grayscale.png", "rubbish.png", "spit.png");
    }
}

