/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.resource;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.ResourceManagerHelper;

public class FontList {
    public static FontList instance = new FontList();
    private Map<String, Font> fonts = new HashMap<String, Font>();
    private boolean fontsLoaded = false;

    public void FontReload() {
        this.fonts.clear();
        this.fontsLoaded = false;
    }

    public void FlonList() {
        if (!this.fontsLoaded) {
            this.loadFont("ces-14x7", "font/ces-14x7.ttf");
            this.loadFont("testfont", "font/schindler-m-series-lop-nz-thin-1-beta.ttf");
            this.loadFont("acmeled", "font/acme-led.ttf");
            this.loadFont("koneModernization", "font/kone-modernization.ttf");
            this.loadFont("schindler_m_series", "font/schindler-m-line-led.ttf");
            this.loadFont("mitsubishi_modern", "font/mitsubishi_modern.ttf");
            this.loadFont("mitsubishi_small_regular", "font/mitsubishi-dot-matrix-small-generic.ttf");
            this.loadFont("mitsubishi_small_sht", "font/mitsubishi-dot-matrix-small-shanghai-tower.ttf");
            this.loadFont("mitsubishi_seg_universal", "font/mitsubishi_seg_universal.ttf");
            this.loadFont("kone-m-series", "font/kone-m-series.ttf");
            this.loadFont("otis_series1", "font/series1.otf");
            this.loadFont("schindler_lcd", "font/schindler_lcd.ttf");
            this.loadFont("schindler_led", "font/schindler-led.ttf");
            this.loadFont("schindler_linea", "font/schindler-linea.ttf");
            this.loadFont("schindler_linea_large", "font/schindler-linea-large.ttf");
            this.loadFont("hitachi_b85", "font/hitachi_b85.ttf");
            this.loadFont("hitachi_b85_left", "font/hitachi_b85_1_left.ttf");
            this.loadFont("nimbus_sans_bold", "font/nimbus_sans_bold.ttf");
            this.loadFont("gill_sans_mt", "font/gill_sans_mt.ttf");
            this.loadFont("hitachi_modern", "font/hitachi_modern.ttf");
            this.loadFont("kone-lcd-segment", "font/kone-lcd-segment.ttf");
            this.loadFont("otis_series_3", "font/otis_series_3.ttf");
            this.loadFont("otis-segmented", "font/otis-segmented.ttf");
            this.loadFont("wqy-microhei", "font/wqy-microhei.ttc");
            this.loadFont("thyssenkrupp_lcd", "font/new-thyssenkrupp.ttf");
            this.loadFont("kone-kss", "font/kone-kss-800-signalization.ttf");
            this.loadFont("hitachi-led-seg", "font/hitachi-led-segmented.ttf");
            this.loadFont("hitachi-led-seg-fix", "font/hitachi_led_segmented_fix.ttf");
            this.loadFont("hitachi-led-dot_matrix", "font/hitachi-dot-matrix-regular.ttf");
            this.loadFont("hitachi-led-dot_matrix_small", "font/hitachi-dot-matrix-small.ttf");
            this.loadFont("hitachi-lcd-seg", "font/hitachi-lcd-segmented.ttf");
            this.loadFont("hitachi-japan-lcd", "font/hitachi-japan-lcd.ttf");
            this.loadFont("hitachi-hip43", "font/hitachi-hip43-lcd.ttf");
            this.loadFont("schindler_m_series_segment", "font/schindler_m_series_segment.ttf");
            this.loadFont("tonic-led", "font/tonic-led.ttf");
            this.loadFont("tonic-led-thin", "font/tonic-thin.ttf");
            this.loadFont("mitsubishi_old_segmented_1", "font/mitsubishi_old_segmented_1.ttf");
            this.loadFont("ryoden-led", "font/ryoden-led.ttf");
            this.loadFont("helvetica", "font/helvetica.ttf");
            this.fontsLoaded = true;
        }
    }

    private void loadFont(String fontName, String resourcePath) {
        ResourceManagerHelper.readResource((Identifier)new Identifier("yte", resourcePath), inputStream -> {
            try {
                Font font = Font.createFont(0, inputStream);
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                ge.registerFont(font);
                this.fonts.put(fontName, font);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public Font getFont(String fontId) {
        Font font = this.fonts.get(fontId);
        if (font != null) {
            return font;
        }
        if (Objects.equals(fontId, "Arial")) {
            return new Font("Arial", 0, 12);
        }
        this.FlonList();
        font = this.fonts.get(fontId);
        if (font != null) {
            return font;
        }
        return new Font("Arial", 0, 12);
    }
}

