/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import java.util.Comparator;
import net.minecraft.core.Vec3i;
import org.mtr.core.data.Lift;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.TonicDSScreen1Even;
import top.xfunny.mod.block.base.LiftPanelBase;
import top.xfunny.mod.client.resource.FontList;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.LiftArrowView;
import top.xfunny.mod.client.view.LiftFloorDisplayView;
import top.xfunny.mod.client.view.LineComponent;
import top.xfunny.mod.client.view.TextView;
import top.xfunny.mod.client.view.view_group.LinearLayout;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;

public class RenderTonicDSScreen1<T extends LiftPanelBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements DirectionHelper,
IGui,
IBlock {
    private final boolean isOdd;

    public RenderTonicDSScreen1(BlockEntityRenderer.Argument dispatcher, Boolean isOdd) {
        super(dispatcher);
        this.isOdd = isOdd;
    }

    public void render(T blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        StoredMatrixTransformations storedMatrixTransformations1 = storedMatrixTransformations.copy();
        storedMatrixTransformations1.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, (double)0.490625f);
        });
        LinearLayout parentLayout = new LinearLayout(false);
        parentLayout.setBasicsAttributes(world, blockPos);
        parentLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        parentLayout.setParentDimensions(0.46875f, 0.3125f);
        parentLayout.setPosition(this.isOdd ? -0.284375f : -0.784375f, 0.5725f);
        parentLayout.setWidth(LayoutSize.MATCH_PARENT);
        parentLayout.setHeight(LayoutSize.MATCH_PARENT);
        LineComponent line = new LineComponent();
        line.setBasicsAttributes(world, blockPos);
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        ((LiftPanelBase.BlockEntityBase)blockEntity).forEachTrackPosition(trackPosition -> {
            line.RenderLine(holdingLinker, (BlockPos)trackPosition);
            TonicDSScreen1Even.LiftCheck(trackPosition, (floorIndex, lift) -> sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift)));
        });
        sortedPositionsAndLifts.sort(Comparator.comparingInt(sortedPositionAndLift -> blockPos.getManhattanDistance(new Vector3i((Vec3i)((BlockPos)sortedPositionAndLift.left()).data))));
        if (!sortedPositionsAndLifts.isEmpty()) {
            boolean count = true;
            for (int i = 0; i < 1; ++i) {
                LiftFloorDisplayView liftFloorDisplayView = new LiftFloorDisplayView();
                liftFloorDisplayView.setBasicsAttributes(world, blockPos, (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), FontList.instance.getFont("acmeled"), 8.0f, -65536);
                liftFloorDisplayView.setTextureId("tonic_ds_screen_1");
                liftFloorDisplayView.setWidth(0.1625f);
                liftFloorDisplayView.setHeight(0.175f);
                liftFloorDisplayView.setGravity(Gravity.CENTER_VERTICAL);
                liftFloorDisplayView.setTextAlign(TextView.HorizontalTextAlign.RIGHT);
                liftFloorDisplayView.setLetterSpacing(0);
                liftFloorDisplayView.setDisplayLength(2, 0.0f);
                liftFloorDisplayView.setMargin(0.09375f, 0.0f, 0.0f, 0.0f);
                liftFloorDisplayView.addStoredMatrixTransformations(graphicsHolder -> graphicsHolder.translate(0.0, 0.0, (double)-0.003125f));
                LiftArrowView liftArrowView_right = new LiftArrowView();
                liftArrowView_right.setBasicsAttributes(world, blockPos, (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), LiftArrowView.ArrowType.DOWN);
                liftArrowView_right.setTexture(new Identifier("yte", "textures/block/dewhurst_ul200_arrow_1.png"));
                liftArrowView_right.setAnimationScrolling(false, 0.05f);
                liftArrowView_right.setDimension(0.0390625f);
                liftArrowView_right.setMargin(0.0703125f, 0.1875f, 0.0f, 0.0f);
                liftArrowView_right.setGravity(Gravity.CENTER_VERTICAL);
                liftArrowView_right.setQueuedRenderLayer(QueuedRenderLayer.LIGHT_TRANSLUCENT);
                liftArrowView_right.setColor(-65536);
                LiftArrowView liftArrowView_left = new LiftArrowView();
                liftArrowView_left.setBasicsAttributes(world, blockPos, (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), LiftArrowView.ArrowType.UP);
                liftArrowView_left.setTexture(new Identifier("yte", "textures/block/dewhurst_ul200_arrow_1.png"));
                liftArrowView_left.setAnimationScrolling(false, 0.05f);
                liftArrowView_left.setDimension(0.0390625f);
                liftArrowView_left.setMargin(-0.359375f, 0.1875f, 0.0f, 0.0f);
                liftArrowView_left.setGravity(Gravity.CENTER_VERTICAL);
                liftArrowView_left.setQueuedRenderLayer(QueuedRenderLayer.LIGHT_TRANSLUCENT);
                liftArrowView_left.setColor(-65536);
                parentLayout.addChild(liftFloorDisplayView);
                parentLayout.addChild(liftArrowView_right);
                parentLayout.addChild(liftArrowView_left);
            }
        }
        parentLayout.render();
    }
}

