/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import java.util.Comparator;
import net.minecraft.core.Vec3i;
import org.mtr.core.data.Lift;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.TestLiftButtons;
import top.xfunny.mod.block.TestLiftButtonsWithoutScreen;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.client.client_data.LiftSpeed;
import top.xfunny.mod.client.resource.FontList;
import top.xfunny.mod.client.view.ButtonView;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.LiftArrowView;
import top.xfunny.mod.client.view.LiftFloorDisplayView;
import top.xfunny.mod.client.view.LineComponent;
import top.xfunny.mod.client.view.TextView;
import top.xfunny.mod.client.view.view_group.FrameLayout;
import top.xfunny.mod.client.view.view_group.LinearLayout;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;
import top.xfunny.mod.keymapping.DefaultButtonsKeyMapping;
import top.xfunny.mod.util.ReverseRendering;

public class RenderTestLiftButtons4
extends BlockEntityRenderer<TestLiftButtons.BlockEntity>
implements DirectionHelper,
IGui,
IBlock {
    private DefaultButtonsKeyMapping keyMapping;
    private LiftSpeed liftSpeed = new LiftSpeed();

    public RenderTestLiftButtons4(BlockEntityRenderer.Argument argument) {
        super(argument);
    }

    public void render(TestLiftButtons.BlockEntity blockEntity, float v, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        this.keyMapping = blockEntity.getKeyMapping();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        LiftButtonsBase.LiftButtonDescriptor buttonDescriptor = new LiftButtonsBase.LiftButtonDescriptor(false, false);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        StoredMatrixTransformations storedMatrixTransformations1 = storedMatrixTransformations.copy();
        storedMatrixTransformations1.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, (double)0.434375f);
        });
        LinearLayout parentLayout = new LinearLayout(true);
        parentLayout.setBasicsAttributes(world, blockPos);
        parentLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        parentLayout.setParentDimensions(0.5f, 1.0f);
        parentLayout.setPosition(-0.25f, 0.0f);
        parentLayout.setWidth(LayoutSize.MATCH_PARENT);
        parentLayout.setHeight(LayoutSize.MATCH_PARENT);
        LinearLayout screenLayout = new LinearLayout(false);
        screenLayout.setBasicsAttributes(world, blockPos);
        screenLayout.setWidth(LayoutSize.WRAP_CONTENT);
        screenLayout.setHeight(LayoutSize.WRAP_CONTENT);
        screenLayout.setGravity(Gravity.CENTER_HORIZONTAL);
        screenLayout.setMargin(0.0f, 0.125f, 0.0f, 0.0f);
        screenLayout.setBackgroundColor(-16777216);
        FrameLayout buttonLayout = new FrameLayout();
        buttonLayout.setBasicsAttributes(world, blockPos);
        buttonLayout.setWidth(LayoutSize.MATCH_PARENT);
        buttonLayout.setHeight(LayoutSize.MATCH_PARENT);
        LinearLayout buttonGroup = new LinearLayout(true);
        buttonGroup.setBasicsAttributes(world, blockPos);
        buttonGroup.setWidth(LayoutSize.WRAP_CONTENT);
        buttonGroup.setHeight(LayoutSize.WRAP_CONTENT);
        buttonGroup.setGravity(Gravity.CENTER);
        ButtonView buttonUp = new ButtonView();
        buttonUp.setId("up");
        buttonUp.setBasicsAttributes(world, blockPos, this.keyMapping);
        buttonUp.setTexture(new Identifier("yte", "textures/block/thyssenkrupp_button.png"));
        buttonUp.setDimension(0.1875f);
        buttonUp.setDefaultColor(-1);
        buttonUp.setPressedColor(-13509);
        buttonUp.setHoverColor(-26317);
        buttonUp.setGravity(Gravity.CENTER_HORIZONTAL);
        buttonUp.setLight(light);
        ButtonView buttonDown = new ButtonView();
        buttonDown.setId("down");
        buttonDown.setBasicsAttributes(world, blockPos, this.keyMapping);
        buttonDown.setTexture(new Identifier("yte", "textures/block/thyssenkrupp_button.png"));
        buttonDown.setDimension(0.1875f);
        buttonDown.setDefaultColor(-1);
        buttonDown.setPressedColor(-16711936);
        buttonDown.setHoverColor(-3342490);
        buttonDown.setGravity(Gravity.CENTER_HORIZONTAL);
        buttonDown.setLight(light);
        buttonDown.setFlip(false, true);
        LineComponent line = new LineComponent();
        line.setBasicsAttributes(world, blockPos);
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        blockEntity.forEachTrackPosition(trackPosition -> {
            line.RenderLine(holdingLinker, (BlockPos)trackPosition);
            TestLiftButtonsWithoutScreen.hasButtonsClient(trackPosition, buttonDescriptor, (floorIndex, lift) -> {
                sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift));
                ObjectArraySet instructionDirections = lift.hasInstruction(floorIndex);
                instructionDirections.forEach(liftDirection -> {
                    switch (liftDirection) {
                        case DOWN: {
                            buttonDown.activate();
                            break;
                        }
                        case UP: {
                            buttonUp.activate();
                        }
                    }
                });
            });
        });
        if (buttonDescriptor.hasUpButton()) {
            buttonGroup.addChild(buttonUp);
        }
        if (buttonDescriptor.hasDownButton()) {
            if (buttonDescriptor.hasUpButton()) {
                buttonDown.setMargin(0.0f, 0.0625f, 0.0f, 0.0f);
            }
            buttonGroup.addChild(buttonDown);
        }
        sortedPositionsAndLifts.sort(Comparator.comparingInt(sortedPositionAndLift -> blockPos.getManhattanDistance(new Vector3i((Vec3i)((BlockPos)sortedPositionAndLift.left()).data))));
        if (!sortedPositionsAndLifts.isEmpty()) {
            int count = Math.min(2, sortedPositionsAndLifts.size());
            boolean reverseRendering = count > 1 && ReverseRendering.reverseRendering(facing.rotateYCounterclockwise(), (BlockPos)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(0)).left(), (BlockPos)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(1)).left());
            for (int i = 0; i < count; ++i) {
                Lift lift = (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right();
                TextView textView = new TextView();
                textView.setBasicsAttributes(world, blockPos, FontList.instance.getFont("wqy-microhei"), 7, -65536);
                textView.setWidth(0.125f);
                textView.setHeight(0.0625f);
                textView.setDisplayLength(10, 0.2f);
                textView.setTextAlign(TextView.HorizontalTextAlign.CENTER);
                textView.setGravity(Gravity.CENTER_HORIZONTAL);
                textView.setText(String.format("%.2f m/s", this.liftSpeed.getSpeed(lift)));
                LiftFloorDisplayView liftFloorDisplayView = new LiftFloorDisplayView();
                liftFloorDisplayView.setBasicsAttributes(world, blockPos, lift, FontList.instance.getFont("acmeled"), 6.0f, -65536);
                liftFloorDisplayView.setDisplayLength(3, 0.05f);
                liftFloorDisplayView.setTextureId("testliftbuttonsdisplay");
                liftFloorDisplayView.setWidth(0.1875f);
                liftFloorDisplayView.setHeight(0.1875f);
                liftFloorDisplayView.setGravity(Gravity.CENTER_HORIZONTAL);
                liftFloorDisplayView.setTextAlign(TextView.HorizontalTextAlign.CENTER);
                LiftArrowView liftArrowView = new LiftArrowView();
                liftArrowView.setBasicsAttributes(world, blockPos, lift, LiftArrowView.ArrowType.AUTO);
                liftArrowView.setTexture(new Identifier("yte", "textures/block/mitsubishi_nexway_1_arrow.png"));
                liftArrowView.setAnimationBliking(true, 0.5f);
                liftArrowView.setDimension(0.125f);
                liftArrowView.setMargin(0.0f, 0.03125f, 0.0f, 0.0f);
                liftArrowView.setGravity(Gravity.CENTER_HORIZONTAL);
                liftArrowView.setColor(-65536);
                liftArrowView.setQueuedRenderLayer(QueuedRenderLayer.LIGHT_TRANSLUCENT);
                LinearLayout numberLayout = new LinearLayout(true);
                numberLayout.setBasicsAttributes(world, blockPos);
                numberLayout.setWidth(LayoutSize.WRAP_CONTENT);
                numberLayout.setHeight(LayoutSize.WRAP_CONTENT);
                numberLayout.addChild(liftArrowView);
                numberLayout.addChild(liftFloorDisplayView);
                numberLayout.addChild(textView);
                if (reverseRendering) {
                    screenLayout.addChild(numberLayout);
                    screenLayout.reverseChildren();
                    continue;
                }
                screenLayout.addChild(numberLayout);
            }
        }
        buttonLayout.addChild(buttonGroup);
        parentLayout.addChild(screenLayout);
        parentLayout.addChild(buttonLayout);
        parentLayout.render();
    }
}

