/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import java.util.Comparator;
import net.minecraft.core.Vec3i;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.HitResult;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MathHelper;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Init;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockLiftTrackFloor;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.TestLiftButtons;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.client.render.RenderLiftObjectLink;
import top.xfunny.mod.client.resource.TextureList;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;
import top.xfunny.mod.util.ClientGetLiftDetails;
import top.xfunny.mod.util.ReverseRendering;

public class RenderTestLiftButtons
extends BlockEntityRenderer<TestLiftButtons.BlockEntity>
implements DirectionHelper,
IGui,
IBlock {
    private static final int HOVER_COLOR = 1437456614;
    private static final int PRESSED_COLOR = -1442840321;
    private static final int GLOW_COLOR = -1996488705;
    private static final float ARROW_SPEED = 0.08f;
    private static final float PULSE_SPEED = 0.05f;
    private static final Identifier ARROW_TEXTURE = new Identifier("mtr", "textures/block/lift_arrow.png");
    private static final Identifier BUTTON_TEXTURE = new Identifier("mtr", "textures/block/lift_button.png");
    private static final Identifier GLOW_TEXTURE = new Identifier("mtr", "textures/block/glow_effect.png");
    private static final Identifier PANEL_TEXTURE = new Identifier("mtr", "textures/block/panel_tech.png");

    public RenderTestLiftButtons(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    public void render(TestLiftButtons.BlockEntity blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        boolean lookingAtTopHalf;
        boolean lookingAtBottomHalf;
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        StoredMatrixTransformations storedMatrixTransformations1 = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        storedMatrixTransformations1.add(graphicsHolder -> graphicsHolder.translate(0.0, Math.sin((double)InitClient.getGameTick() * 0.1) * 0.01, 0.0));
        boolean[] buttonStates = new boolean[]{false, false};
        LiftButtonsBase.LiftButtonDescriptor buttonDescriptor = new LiftButtonsBase.LiftButtonDescriptor(false, false);
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        blockEntity.forEachTrackPosition(trackPosition -> {
            if (world.getBlockState((BlockPos)trackPosition).getBlock().data instanceof BlockLiftTrackFloor) {
                Direction trackFacing = IBlock.getStatePropertySafe((World)world, (BlockPos)trackPosition, (DirectionProperty)FACING);
                RenderLiftObjectLink.RenderLiftObjectLink(storedMatrixTransformations1, new Vector3d((double)((float)facing.getOffsetX() / 2.0f), 0.5, (double)((float)facing.getOffsetZ() / 2.0f)), new Vector3d((double)((float)(trackPosition.getX() - blockPos.getX()) + (float)trackFacing.getOffsetX() / 2.0f), (double)(trackPosition.getY() - blockPos.getY()) + 0.5, (double)((float)(trackPosition.getZ() - blockPos.getZ()) + (float)trackFacing.getOffsetZ() / 2.0f)), holdingLinker);
            }
            TestLiftButtons.hasButtonsClient(trackPosition, buttonDescriptor, (floorIndex, lift) -> {
                sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift));
                ObjectArraySet instructionDirections = lift.hasInstruction(floorIndex);
                instructionDirections.forEach(liftDirection -> {
                    if (liftDirection == LiftDirection.DOWN) {
                        buttonStates[0] = true;
                    }
                    if (liftDirection == LiftDirection.UP) {
                        buttonStates[1] = true;
                    }
                });
            });
        });
        sortedPositionsAndLifts.sort(Comparator.comparingInt(sortedPositionAndLift -> blockPos.getManhattanDistance(new Vector3i((Vec3i)((BlockPos)sortedPositionAndLift.left()).data))));
        HitResult hitResult = MinecraftClient.getInstance().getCrosshairTargetMapped();
        if (hitResult == null || !IBlock.getStatePropertySafe((BlockState)blockState, (BooleanProperty)TestLiftButtons.UNLOCKED)) {
            lookingAtBottomHalf = false;
            lookingAtTopHalf = false;
        } else {
            Vector3d hitLocation = hitResult.getPos();
            double hitY = MathHelper.fractionalPart((double)hitLocation.getYMapped());
            boolean inBlock = hitY < 0.5 && Init.newBlockPos((double)hitLocation.getXMapped(), (double)hitLocation.getYMapped(), (double)hitLocation.getZMapped()).equals((Object)blockPos);
            lookingAtTopHalf = inBlock && (!buttonDescriptor.hasDownButton() || hitY > 0.25);
            lookingAtBottomHalf = inBlock && (!buttonDescriptor.hasUpButton() || hitY < 0.25);
        }
        StoredMatrixTransformations storedMatrixTransformations2 = storedMatrixTransformations1.copy();
        storedMatrixTransformations2.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, 0.43437499995343387);
        });
        this.renderButton(storedMatrixTransformations2, buttonDescriptor.hasDownButton(), buttonStates[0], lookingAtBottomHalf, buttonDescriptor.hasUpButton() ? 0.5f : 2.5f, false, light);
        this.renderButton(storedMatrixTransformations2, buttonDescriptor.hasUpButton(), buttonStates[1], lookingAtTopHalf, buttonDescriptor.hasDownButton() ? 4.5f : 2.5f, true, light);
        if (!sortedPositionsAndLifts.isEmpty()) {
            int count = Math.min(2, sortedPositionsAndLifts.size());
            float width = count == 1 ? 0.25f : 0.495f;
            StoredMatrixTransformations storedMatrixTransformations3 = storedMatrixTransformations2.copy();
            storedMatrixTransformations3.add(graphicsHolder -> {
                graphicsHolder.rotateZDegrees(180.0f);
                graphicsHolder.translate((double)(-width / 2.0f), 0.0, 0.0);
            });
            MainRenderer.scheduleRender((Identifier)PANEL_TEXTURE, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                storedMatrixTransformations3.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)0.0f, (float)-0.9375f, (float)width, (float)0.40625f, (Direction)Direction.UP, (int)light);
                this.renderGlowEffect((GraphicsHolder)graphicsHolder, width, 0.40625f, light);
                graphicsHolder.pop();
            });
            boolean reverseRendering = count > 1 && ReverseRendering.reverseRendering(facing.rotateYCounterclockwise(), (BlockPos)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(0)).left(), (BlockPos)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(1)).left());
            for (int i = 0; i < count; ++i) {
                double x = ((double)(reverseRendering ? count - i - 1 : i) + 0.5) * (double)width / (double)count;
                StoredMatrixTransformations storedMatrixTransformations4 = storedMatrixTransformations3.copy();
                int finalI = i;
                storedMatrixTransformations4.add(graphicsHolder -> {
                    graphicsHolder.translate(x, -0.875, (double)-0.003125f);
                    graphicsHolder.scale(1.0f, 1.0f, (float)(1.0 + Math.sin((double)InitClient.getGameTick() * 0.2 + (double)finalI) * 0.05));
                });
                this.renderLiftDisplay(storedMatrixTransformations4, world, (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), width * 4.0f / (float)count, 0.2f, 0.2f, 0.2f);
            }
        }
    }

    private void renderButton(StoredMatrixTransformations transformations, boolean hasButton, boolean isPressed, boolean isHovered, float yOffset, boolean isUpButton, int light) {
        if (!hasButton) {
            return;
        }
        int buttonColor = isPressed ? -1442840321 : (isHovered ? 1437456614 : -10066330);
        MainRenderer.scheduleRender((Identifier)GLOW_TEXTURE, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
            transformations.transform(graphicsHolder, offset);
            if (isPressed || isHovered) {
                float pulse = (float)(0.7 + Math.sin(InitClient.getGameTick() * 0.05f) * 0.3);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)-0.125f, (float)((yOffset - 1.0f) / 16.0f), (float)0.3125f, (float)0.3125f, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)((isPressed ? -1442840321 : 1437456614) & 0xFFFFFF | (int)(pulse * 255.0f) << 24), (int)light);
            }
            graphicsHolder.pop();
        });
        MainRenderer.scheduleRender((Identifier)BUTTON_TEXTURE, (boolean)false, (QueuedRenderLayer)(isPressed || isHovered ? QueuedRenderLayer.LIGHT_TRANSLUCENT : QueuedRenderLayer.EXTERIOR), (graphicsHolder, offset) -> {
            transformations.transform(graphicsHolder, offset);
            IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)-0.09375f, (float)(yOffset / 16.0f), (float)0.1875f, (float)0.1875f, (float)0.0f, (float)(isUpButton ? 1.0f : 0.0f), (float)1.0f, (float)(isUpButton ? 0.0f : 1.0f), (Direction)Direction.UP, (int)buttonColor, (int)light);
            graphicsHolder.pop();
        });
    }

    private void renderGlowEffect(GraphicsHolder graphicsHolder, float width, float height, int light) {
        float pulse = (float)(0.5 + Math.sin((double)InitClient.getGameTick() * 0.1) * 0.5);
        IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)-0.01f, (float)-0.01f, (float)(width + 0.02f), (float)(height + 0.02f), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)(0xFFFFFF | (int)(pulse * 88.0f) << 24), (int)light);
    }

    private void renderLiftDisplay(StoredMatrixTransformations storedMatrixTransformations, World world, Lift lift, float width, float width1, float height1, float height) {
        ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = ClientGetLiftDetails.getLiftDetails(world, lift, Init.positionToBlockPos((Position)lift.getCurrentFloor().getPosition()));
        LiftDirection liftDirection = (LiftDirection)liftDetails.left();
        String floorNumber = (String)((ObjectObjectImmutablePair)liftDetails.right()).left();
        String floorDescription = (String)((ObjectObjectImmutablePair)liftDetails.right()).right();
        boolean noFloorNumber = floorNumber.isEmpty();
        boolean noFloorDisplay = floorDescription.isEmpty();
        float gameTick = InitClient.getGameTick();
        boolean goingUp = liftDirection == LiftDirection.UP;
        float arrowSize = width / 6.0f;
        float y = height;
        if (liftDirection != LiftDirection.NONE) {
            float uv = gameTick * 0.08f % 1.0f;
            int color = goingUp ? -16711936 : -65536;
            MainRenderer.scheduleRender((Identifier)GLOW_TEXTURE, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                storedMatrixTransformations.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(-width / 4.0f + arrowSize - 0.02f), (float)(y - 0.24f - 0.02f), (float)(arrowSize + 0.04f), (float)(arrowSize + 0.04f), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)(color & 0xFFFFFF | 0x55000000), (int)158999999);
                graphicsHolder.pop();
            });
            MainRenderer.scheduleRender((Identifier)ARROW_TEXTURE, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                storedMatrixTransformations.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(-width / 4.0f + arrowSize), (float)(y - 0.24f), (float)arrowSize, (float)arrowSize, (float)0.0f, (float)((float)(!goingUp ? 1 : 0) + uv), (float)1.0f, (float)((float)(goingUp ? 1 : 0) + uv), (Direction)Direction.UP, (int)color, (int)GraphicsHolder.getDefaultLight());
                graphicsHolder.pop();
            });
        }
        if (!noFloorNumber || !noFloorDisplay) {
            String text = String.format("%s%s", floorNumber, noFloorNumber ? " " : "");
            int totalWidth = TextureList.instance.getTestLiftButtonsDisplay((String)text, (int)0xFFAA00).width;
            MainRenderer.scheduleRender((Identifier)GLOW_TEXTURE, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                storedMatrixTransformations.transform(graphicsHolder, offset);
                IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(-width + 0.88f), (float)(y - 0.08f), (float)(width1 + 0.04f), (float)(height1 + 0.04f), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)0x22FFFFFF, (int)158999999);
                graphicsHolder.pop();
            });
            if (text.length() > 2) {
                float scrollSpeed = 0.01f;
                float offset1 = gameTick * scrollSpeed % ((float)totalWidth + width1);
                MainRenderer.scheduleRender((Identifier)TextureList.instance.getTestLiftButtonsDisplay((String)text, (int)0xFFAA00).identifier, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolder, offset);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(-width + 0.9f), (float)(y - 0.07f), (float)width1, (float)height1, (float)offset1, (float)0.0f, (float)(offset1 + 170.0f / (float)totalWidth), (float)1.0f, (Direction)Direction.UP, (int)-1, (int)GraphicsHolder.getDefaultLight());
                    graphicsHolder.pop();
                });
            } else {
                float pulse = (float)(0.8 + Math.sin((double)gameTick * 0.2) * 0.2);
                MainRenderer.scheduleRender((Identifier)TextureList.instance.getTestLiftButtonsDisplay((String)text, (int)0xFFAA00).identifier, (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolder, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolder, offset);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolder, (float)(-width + 0.9f), (float)(y - 0.07f), (float)(width1 * pulse), (float)(height1 * pulse), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)(0xFFFFFFFF | (int)(pulse * 255.0f) << 24), (int)GraphicsHolder.getDefaultLight());
                    graphicsHolder.pop();
                });
            }
        }
    }
}

