/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import java.util.Comparator;
import net.minecraft.core.Vec3i;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Init;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.SchindlerMSeriesScreen4Even;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.client.resource.FontList;
import top.xfunny.mod.client.view.ButtonView;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.LiftFloorDisplayView;
import top.xfunny.mod.client.view.LineComponent;
import top.xfunny.mod.client.view.TextView;
import top.xfunny.mod.client.view.view_group.FrameLayout;
import top.xfunny.mod.client.view.view_group.LinearLayout;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;
import top.xfunny.mod.util.ClientGetLiftDetails;

public class RenderSchindlerMSeriesScreen4<T extends LiftButtonsBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements DirectionHelper,
IGui,
IBlock {
    private static final Identifier BUTTON_TEXTURE = new Identifier("yte", "textures/block/schindler_m_series_screen_4_arrow.png");
    private static final int PRESSED_COLOR = -65536;
    private static final int DEFAULT_COLOR = -11730944;
    private final boolean isOdd;

    public RenderSchindlerMSeriesScreen4(BlockEntityRenderer.Argument dispatcher, Boolean isOdd) {
        super(dispatcher);
        this.isOdd = isOdd;
    }

    public void render(T blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        LiftButtonsBase.LiftButtonDescriptor buttonDescriptor = new LiftButtonsBase.LiftButtonDescriptor(false, false);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        StoredMatrixTransformations storedMatrixTransformations1 = storedMatrixTransformations.copy();
        storedMatrixTransformations1.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, (double)0.490625f);
        });
        LinearLayout parentLayout = new LinearLayout(false);
        parentLayout.setBasicsAttributes(world, blockPos);
        parentLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        parentLayout.setParentDimensions(0.5625f, 0.125f);
        parentLayout.setPosition(this.isOdd ? -0.28125f : -0.78125f, 0.59375f);
        parentLayout.setWidth(LayoutSize.MATCH_PARENT);
        parentLayout.setHeight(LayoutSize.MATCH_PARENT);
        FrameLayout screenLayout = new FrameLayout();
        screenLayout.setBasicsAttributes(world, blockEntity.getPos2());
        screenLayout.setWidth(LayoutSize.WRAP_CONTENT);
        screenLayout.setHeight(LayoutSize.WRAP_CONTENT);
        screenLayout.setGravity(Gravity.CENTER_VERTICAL);
        screenLayout.setMargin(0.05625f, 0.0f, 0.0f, 0.0f);
        ButtonView upLanternLeft = new ButtonView();
        upLanternLeft.setBasicsAttributes(world, blockEntity.getPos2());
        upLanternLeft.setTexture(BUTTON_TEXTURE);
        upLanternLeft.setDimension(0.0390625f);
        upLanternLeft.setGravity(Gravity.CENTER_VERTICAL);
        upLanternLeft.setLight(light);
        upLanternLeft.setDefaultColor(-11730944);
        upLanternLeft.setPressedColor(-65536);
        upLanternLeft.setMargin(0.078125f, 0.0f, 0.0f, 0.0f);
        ButtonView upLanternRight = new ButtonView();
        upLanternRight.setBasicsAttributes(world, blockEntity.getPos2());
        upLanternRight.setTexture(BUTTON_TEXTURE);
        upLanternRight.setDimension(0.0390625f);
        upLanternRight.setGravity(Gravity.CENTER_VERTICAL);
        upLanternRight.setLight(light);
        upLanternRight.setDefaultColor(-11730944);
        upLanternRight.setPressedColor(-65536);
        upLanternRight.setMargin(0.109375f, 0.0f, 0.0f, 0.0f);
        ButtonView downLanternLeft = new ButtonView();
        downLanternLeft.setBasicsAttributes(world, blockEntity.getPos2());
        downLanternLeft.setTexture(BUTTON_TEXTURE);
        downLanternLeft.setDimension(0.0390625f);
        downLanternLeft.setGravity(Gravity.CENTER_VERTICAL);
        downLanternLeft.setLight(light);
        downLanternLeft.setDefaultColor(-11730944);
        downLanternLeft.setPressedColor(-65536);
        downLanternLeft.setFlip(false, true);
        downLanternLeft.setMargin(0.078125f, 0.0f, 0.0f, 0.0f);
        ButtonView downLanternRight = new ButtonView();
        downLanternRight.setBasicsAttributes(world, blockEntity.getPos2());
        downLanternRight.setTexture(BUTTON_TEXTURE);
        downLanternRight.setDimension(0.0390625f);
        downLanternRight.setGravity(Gravity.CENTER_VERTICAL);
        downLanternRight.setLight(light);
        downLanternRight.setDefaultColor(-11730944);
        downLanternRight.setPressedColor(-65536);
        downLanternRight.setFlip(false, true);
        downLanternRight.setMargin(0.109375f, 0.0f, 0.0f, 0.0f);
        LineComponent line = new LineComponent();
        line.setBasicsAttributes(world, blockPos);
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        ((LiftButtonsBase.BlockEntityBase)blockEntity).forEachTrackPosition(trackPosition -> {
            line.RenderLine(holdingLinker, (BlockPos)trackPosition);
            SchindlerMSeriesScreen4Even.hasButtonsClient(trackPosition, buttonDescriptor, (floorIndex, lift) -> {
                sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift));
                ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = ClientGetLiftDetails.getLiftDetails(world, lift, Init.positionToBlockPos((Position)lift.getCurrentFloor().getPosition()));
                LiftDirection liftDirection = (LiftDirection)liftDetails.left();
                switch (liftDirection) {
                    case UP: {
                        upLanternRight.activate();
                        upLanternLeft.activate();
                        break;
                    }
                    case DOWN: {
                        downLanternRight.activate();
                        downLanternLeft.activate();
                    }
                }
            });
        });
        sortedPositionsAndLifts.sort(Comparator.comparingInt(sortedPositionAndLift -> blockPos.getManhattanDistance(new Vector3i((Vec3i)((BlockPos)sortedPositionAndLift.left()).data))));
        if (!sortedPositionsAndLifts.isEmpty()) {
            boolean count = true;
            for (int i = 0; i < 1; ++i) {
                LiftFloorDisplayView liftFloorDisplayView = new LiftFloorDisplayView();
                liftFloorDisplayView.setBasicsAttributes(world, blockPos, (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), FontList.instance.getFont("schindler_m_series_segment"), 3.0f, -65536);
                liftFloorDisplayView.setTextureId("schindler_m_series_screen_4");
                liftFloorDisplayView.setWidth(0.1625f);
                liftFloorDisplayView.setHeight(0.175f);
                liftFloorDisplayView.setGravity(Gravity.CENTER_VERTICAL);
                liftFloorDisplayView.setTextAlign(TextView.HorizontalTextAlign.RIGHT);
                liftFloorDisplayView.setLetterSpacing(0);
                liftFloorDisplayView.setDisplayLength(2, 0.0f);
                liftFloorDisplayView.addStoredMatrixTransformations(graphicsHolder -> graphicsHolder.translate(0.0, 0.0, (double)-0.003125f));
                liftFloorDisplayView.setGravity(Gravity.CENTER);
                screenLayout.addChild(liftFloorDisplayView);
            }
        }
        if (buttonDescriptor.hasDownButton() && buttonDescriptor.hasUpButton()) {
            parentLayout.addChild(downLanternLeft);
            parentLayout.addChild(screenLayout);
            parentLayout.addChild(upLanternRight);
        } else if (buttonDescriptor.hasDownButton()) {
            parentLayout.addChild(downLanternLeft);
            parentLayout.addChild(screenLayout);
            parentLayout.addChild(upLanternRight);
        } else if (buttonDescriptor.hasUpButton()) {
            parentLayout.addChild(downLanternLeft);
            parentLayout.addChild(screenLayout);
            parentLayout.addChild(upLanternRight);
        }
        parentLayout.render();
    }
}

