/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import java.util.Comparator;
import net.minecraft.core.Vec3i;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Init;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.RenderLifts;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.SchindlerMSeriesScreen3Even;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.client.resource.FontList;
import top.xfunny.mod.client.view.ButtonView;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.ImageView;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.LiftFloorDisplayView;
import top.xfunny.mod.client.view.LineComponent;
import top.xfunny.mod.client.view.TextView;
import top.xfunny.mod.client.view.view_group.FrameLayout;
import top.xfunny.mod.client.view.view_group.LinearLayout;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;
import top.xfunny.mod.util.ClientGetLiftDetails;

public class RenderSchindlerMSeriesScreen3<T extends LiftButtonsBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements DirectionHelper,
IGui,
IBlock {
    private static final int PRESSED_COLOR = -13312;
    private static final int DEFAULT_COLOR = -1;
    private static final Identifier ARROW_TEXTURE = new Identifier("yte", "textures/block/schindler_m_series_panel_arrow_2.png");
    private static final Identifier BUTTON_TEXTURE = new Identifier("yte", "textures/block/schindler_m_series_lantern_3.png");
    private static final Identifier SCREEN_TEXTURE = new Identifier("yte", "textures/block/schindler_m_series_screen_1_white.png");
    private final boolean isOdd;

    public RenderSchindlerMSeriesScreen3(BlockEntityRenderer.Argument dispatcher, Boolean isOdd) {
        super(dispatcher);
        this.isOdd = isOdd;
    }

    public void render(T blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        LiftButtonsBase.LiftButtonDescriptor buttonDescriptor = new LiftButtonsBase.LiftButtonDescriptor(false, false);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        StoredMatrixTransformations storedMatrixTransformations1 = storedMatrixTransformations.copy();
        storedMatrixTransformations1.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, (double)0.490625f);
        });
        FrameLayout parentLayout = new FrameLayout();
        parentLayout.setBasicsAttributes(world, blockPos);
        parentLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        parentLayout.setParentDimensions(1.125f, 0.28125f);
        parentLayout.setPosition(this.isOdd ? -0.5575f : -1.055f, 0.61f);
        parentLayout.setWidth(LayoutSize.MATCH_PARENT);
        parentLayout.setHeight(LayoutSize.MATCH_PARENT);
        LinearLayout linearLayout = new LinearLayout(false);
        linearLayout.setBasicsAttributes(world, blockPos);
        linearLayout.setHeight(LayoutSize.WRAP_CONTENT);
        linearLayout.setWidth(LayoutSize.WRAP_CONTENT);
        linearLayout.setGravity(Gravity.CENTER);
        FrameLayout screenLayout = new FrameLayout();
        screenLayout.setBasicsAttributes(world, blockPos);
        screenLayout.setWidth(LayoutSize.WRAP_CONTENT);
        screenLayout.setHeight(LayoutSize.WRAP_CONTENT);
        screenLayout.setGravity(Gravity.CENTER_VERTICAL);
        screenLayout.setMargin(0.0f, 0.0f, 0.09375f, 0.0f);
        FrameLayout LanternGroupLeft = new FrameLayout();
        LanternGroupLeft.setBasicsAttributes(world, blockPos);
        LanternGroupLeft.setWidth(LayoutSize.WRAP_CONTENT);
        LanternGroupLeft.setHeight(LayoutSize.WRAP_CONTENT);
        LanternGroupLeft.setGravity(Gravity.CENTER_VERTICAL);
        LanternGroupLeft.setMargin(0.0f, 0.0f, 0.09375f, 0.0f);
        FrameLayout LanternGroupRight = new FrameLayout();
        LanternGroupRight.setBasicsAttributes(world, blockPos);
        LanternGroupRight.setWidth(LayoutSize.WRAP_CONTENT);
        LanternGroupRight.setHeight(LayoutSize.WRAP_CONTENT);
        LanternGroupRight.setGravity(Gravity.CENTER_VERTICAL);
        ImageView lanternBackgroundLeft = new ImageView();
        lanternBackgroundLeft.setBasicsAttributes(world, blockPos);
        lanternBackgroundLeft.setTexture(BUTTON_TEXTURE);
        lanternBackgroundLeft.setDimension(0.203125f);
        lanternBackgroundLeft.setGravity(Gravity.CENTER);
        lanternBackgroundLeft.setLight(light);
        ImageView lanternBackgroundRight = new ImageView();
        lanternBackgroundRight.setBasicsAttributes(world, blockPos);
        lanternBackgroundRight.setTexture(BUTTON_TEXTURE);
        lanternBackgroundRight.setDimension(0.203125f);
        lanternBackgroundRight.setGravity(Gravity.CENTER);
        lanternBackgroundRight.setLight(light);
        ImageView background = new ImageView();
        background.setBasicsAttributes(world, blockPos);
        background.setTexture(SCREEN_TEXTURE);
        background.setDimension(0.203125f);
        background.setLight(light);
        background.setGravity(Gravity.CENTER);
        ButtonView upLanternLeft = new ButtonView();
        upLanternLeft.setBasicsAttributes(world, blockEntity.getPos2());
        upLanternLeft.setTexture(ARROW_TEXTURE);
        upLanternLeft.setDimension(0.203125f);
        upLanternLeft.setGravity(Gravity.CENTER);
        upLanternLeft.setLight(light);
        upLanternLeft.setDefaultColor(-1);
        upLanternLeft.setPressedColor(-13312);
        ButtonView upLanternRight = new ButtonView();
        upLanternRight.setBasicsAttributes(world, blockEntity.getPos2());
        upLanternRight.setTexture(ARROW_TEXTURE);
        upLanternRight.setDimension(0.203125f);
        upLanternRight.setGravity(Gravity.CENTER);
        upLanternRight.setLight(light);
        upLanternRight.setDefaultColor(-1);
        upLanternRight.setPressedColor(-13312);
        ButtonView downLanternLeft = new ButtonView();
        downLanternLeft.setBasicsAttributes(world, blockEntity.getPos2());
        downLanternLeft.setTexture(ARROW_TEXTURE);
        downLanternLeft.setDimension(0.203125f);
        downLanternLeft.setGravity(Gravity.CENTER);
        downLanternLeft.setLight(light);
        downLanternLeft.setDefaultColor(-1);
        downLanternLeft.setPressedColor(-13312);
        downLanternLeft.setFlip(false, true);
        ButtonView downLanternRight = new ButtonView();
        downLanternRight.setBasicsAttributes(world, blockEntity.getPos2());
        downLanternRight.setTexture(ARROW_TEXTURE);
        downLanternRight.setDimension(0.203125f);
        downLanternRight.setGravity(Gravity.CENTER);
        downLanternRight.setLight(light);
        downLanternRight.setDefaultColor(-1);
        downLanternRight.setPressedColor(-13312);
        downLanternRight.setFlip(false, true);
        LineComponent line = new LineComponent();
        line.setBasicsAttributes(world, blockPos);
        LineComponent buttonLine = new LineComponent();
        buttonLine.setBasicsAttributes(world, blockPos);
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        ((LiftButtonsBase.BlockEntityBase)blockEntity).forEachTrackPosition(trackPosition -> {
            line.RenderLine(holdingLinker, (BlockPos)trackPosition);
            SchindlerMSeriesScreen3Even.hasButtonsClient(trackPosition, buttonDescriptor, (floorIndex, lift) -> {
                sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift));
                LiftDirection pressedButtonDirection = blockEntity.getPressedButtonDirection();
                ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = ClientGetLiftDetails.getLiftDetails(world, lift, Init.positionToBlockPos((Position)lift.getCurrentFloor().getPosition()));
                String floorNumber = (String)((ObjectObjectImmutablePair)liftDetails.right()).left();
                String currentFloorNumber = (String)((ObjectObjectImmutablePair)RenderLifts.getLiftDetails((World)world, (Lift)lift, (BlockPos)trackPosition).right()).left();
                ObjectArraySet instructionDirections = lift.hasInstruction(floorIndex);
                if (instructionDirections.isEmpty() && pressedButtonDirection != null && lift.getDoorValue() != 0.0f && floorNumber.equals(currentFloorNumber)) {
                    switch (pressedButtonDirection) {
                        case DOWN: {
                            downLanternLeft.activate();
                            downLanternRight.activate();
                            break;
                        }
                        case UP: {
                            upLanternLeft.activate();
                            upLanternRight.activate();
                        }
                    }
                }
                instructionDirections.forEach(liftDirection -> {
                    if (lift.getDoorValue() != 0.0f && floorNumber.equals(currentFloorNumber)) {
                        if (liftDirection == LiftDirection.NONE) {
                            if (pressedButtonDirection != null) {
                                switch (pressedButtonDirection) {
                                    case DOWN: {
                                        downLanternLeft.activate();
                                        downLanternRight.activate();
                                        break;
                                    }
                                    case UP: {
                                        upLanternLeft.activate();
                                        upLanternRight.activate();
                                    }
                                }
                            }
                        } else {
                            switch (liftDirection) {
                                case DOWN: {
                                    downLanternLeft.activate();
                                    downLanternRight.activate();
                                    break;
                                }
                                case UP: {
                                    upLanternLeft.activate();
                                    upLanternRight.activate();
                                }
                            }
                        }
                    }
                });
            });
        });
        sortedPositionsAndLifts.sort(Comparator.comparingInt(sortedPositionAndLift -> blockPos.getManhattanDistance(new Vector3i((Vec3i)((BlockPos)sortedPositionAndLift.left()).data))));
        if (!sortedPositionsAndLifts.isEmpty()) {
            boolean count = true;
            for (int i = 0; i < 1; ++i) {
                LiftFloorDisplayView liftFloorDisplayView = new LiftFloorDisplayView();
                liftFloorDisplayView.setBasicsAttributes(world, blockPos, (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), FontList.instance.getFont("schindler_m_series_segment"), 4.0f, -65536);
                liftFloorDisplayView.setDisplayLength(2, 0.0f);
                liftFloorDisplayView.setTextureId("schindler_m_series_screen_3_display");
                liftFloorDisplayView.setWidth(0.125f);
                liftFloorDisplayView.setHeight(0.125f);
                liftFloorDisplayView.setTextAlign(TextView.HorizontalTextAlign.RIGHT);
                liftFloorDisplayView.setMargin(0.028125f, 0.0f, 0.0f, 0.0f);
                liftFloorDisplayView.setGravity(Gravity.CENTER);
                screenLayout.addChild(background);
                screenLayout.addChild(liftFloorDisplayView);
            }
        }
        ((LiftButtonsBase.BlockEntityBase)blockEntity).forEachLiftButtonPosition(buttonPosition -> buttonLine.RenderLine(holdingLinker, (BlockPos)buttonPosition, true));
        if (buttonDescriptor.hasDownButton() && buttonDescriptor.hasUpButton()) {
            LanternGroupLeft.addChild(lanternBackgroundLeft);
            LanternGroupLeft.addChild(downLanternLeft);
            LanternGroupRight.addChild(lanternBackgroundRight);
            LanternGroupRight.addChild(upLanternRight);
            linearLayout.addChild(LanternGroupLeft);
            linearLayout.addChild(screenLayout);
            linearLayout.addChild(LanternGroupRight);
        } else if (buttonDescriptor.hasDownButton()) {
            LanternGroupLeft.addChild(lanternBackgroundLeft);
            LanternGroupLeft.addChild(downLanternLeft);
            LanternGroupRight.addChild(lanternBackgroundRight);
            LanternGroupRight.addChild(downLanternRight);
            linearLayout.addChild(LanternGroupLeft);
            linearLayout.addChild(screenLayout);
            linearLayout.addChild(LanternGroupRight);
        } else if (buttonDescriptor.hasUpButton()) {
            LanternGroupLeft.addChild(lanternBackgroundLeft);
            LanternGroupLeft.addChild(upLanternLeft);
            LanternGroupRight.addChild(lanternBackgroundRight);
            LanternGroupRight.addChild(upLanternRight);
            linearLayout.addChild(LanternGroupLeft);
            linearLayout.addChild(screenLayout);
            linearLayout.addChild(LanternGroupRight);
        }
        parentLayout.addChild(linearLayout);
        parentLayout.render();
    }
}

