/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Init;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.RenderLifts;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.SchindlerMSeriesRoundLantern1Even;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.client.view.ButtonView;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.LineComponent;
import top.xfunny.mod.client.view.view_group.LinearLayout;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;
import top.xfunny.mod.util.ClientGetLiftDetails;

public class RenderOtisSeries3Lantern1Arrow<T extends LiftButtonsBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements DirectionHelper,
IGui,
IBlock {
    private static final int PRESSED_COLOR_UP = -16711936;
    private static final int PRESSED_COLOR_DOWN = -65536;
    private static final int DEFAULT_COLOR = -14540254;
    private static final Identifier BUTTON_TEXTURE = new Identifier("yte", "textures/block/otis_s3_lantern_1_arrow.png");
    private final boolean isOdd;

    public RenderOtisSeries3Lantern1Arrow(BlockEntityRenderer.Argument dispatcher, Boolean isOdd) {
        super(dispatcher);
        this.isOdd = isOdd;
    }

    public void render(T blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        LiftButtonsBase.LiftButtonDescriptor buttonDescriptor = new LiftButtonsBase.LiftButtonDescriptor(false, false);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        StoredMatrixTransformations storedMatrixTransformations1 = storedMatrixTransformations.copy();
        storedMatrixTransformations1.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, (double)0.475f);
        });
        LinearLayout parentLayout = new LinearLayout(true);
        parentLayout.setBasicsAttributes(world, blockPos);
        parentLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        parentLayout.setParentDimensions(0.46875f, 0.284375f);
        parentLayout.setPosition(this.isOdd ? -0.234375f : -0.734375f, 0.3578125f);
        parentLayout.setWidth(LayoutSize.MATCH_PARENT);
        parentLayout.setHeight(LayoutSize.MATCH_PARENT);
        ButtonView upLantern = new ButtonView();
        upLantern.setBasicsAttributes(world, blockPos);
        upLantern.setTexture(BUTTON_TEXTURE);
        upLantern.setDimension(0.075f);
        upLantern.setGravity(Gravity.CENTER_HORIZONTAL);
        upLantern.setLight(light);
        upLantern.setDefaultColor(-14540254);
        upLantern.setPressedColor(-16711936);
        upLantern.setMargin(0.0f, 0.03125f, 0.0f, 0.06875f);
        ButtonView downLantern = new ButtonView();
        downLantern.setBasicsAttributes(world, blockPos);
        downLantern.setTexture(BUTTON_TEXTURE);
        downLantern.setDimension(0.075f);
        downLantern.setGravity(Gravity.CENTER_HORIZONTAL);
        downLantern.setLight(light);
        downLantern.setDefaultColor(-14540254);
        downLantern.setPressedColor(-65536);
        downLantern.setFlip(false, true);
        downLantern.setMargin(0.0f, 0.0f, 0.0f, 0.0f);
        LineComponent line = new LineComponent();
        line.setBasicsAttributes(world, blockPos);
        LineComponent buttonLine = new LineComponent();
        buttonLine.setBasicsAttributes(world, blockPos);
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        ((LiftButtonsBase.BlockEntityBase)blockEntity).forEachTrackPosition(trackPosition -> {
            line.RenderLine(holdingLinker, (BlockPos)trackPosition);
            SchindlerMSeriesRoundLantern1Even.hasButtonsClient(trackPosition, buttonDescriptor, (floorIndex, lift) -> {
                sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift));
                LiftDirection pressedButtonDirection = blockEntity.getPressedButtonDirection();
                ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = ClientGetLiftDetails.getLiftDetails(world, lift, Init.positionToBlockPos((Position)lift.getCurrentFloor().getPosition()));
                String floorNumber = (String)((ObjectObjectImmutablePair)liftDetails.right()).left();
                String currentFloorNumber = (String)((ObjectObjectImmutablePair)RenderLifts.getLiftDetails((World)world, (Lift)lift, (BlockPos)trackPosition).right()).left();
                ObjectArraySet instructionDirections = lift.hasInstruction(floorIndex);
                if (instructionDirections.isEmpty() && pressedButtonDirection != null && lift.getDoorValue() != 0.0f && floorNumber.equals(currentFloorNumber)) {
                    switch (pressedButtonDirection) {
                        case DOWN: {
                            downLantern.activate();
                            break;
                        }
                        case UP: {
                            upLantern.activate();
                        }
                    }
                }
                instructionDirections.forEach(liftDirection -> {
                    if (lift.getDoorValue() != 0.0f && floorNumber.equals(currentFloorNumber)) {
                        if (liftDirection == LiftDirection.NONE) {
                            if (pressedButtonDirection != null) {
                                switch (pressedButtonDirection) {
                                    case DOWN: {
                                        downLantern.activate();
                                        break;
                                    }
                                    case UP: {
                                        upLantern.activate();
                                    }
                                }
                            }
                        } else {
                            switch (liftDirection) {
                                case DOWN: {
                                    downLantern.activate();
                                    break;
                                }
                                case UP: {
                                    upLantern.activate();
                                }
                            }
                        }
                    }
                });
            });
        });
        ((LiftButtonsBase.BlockEntityBase)blockEntity).forEachLiftButtonPosition(buttonPosition -> buttonLine.RenderLine(holdingLinker, (BlockPos)buttonPosition, true));
        if (buttonDescriptor.hasUpButton() || buttonDescriptor.hasDownButton()) {
            parentLayout.addChild(upLantern);
            parentLayout.addChild(downLantern);
        }
        parentLayout.render();
    }
}

