/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.OtisSeries3Button1;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.client.view.ButtonView;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.ImageView;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.LineComponent;
import top.xfunny.mod.client.view.view_group.FrameLayout;
import top.xfunny.mod.client.view.view_group.LinearLayout;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;
import top.xfunny.mod.keymapping.DefaultButtonsKeyMapping;

public class RenderOtisSeries3Button1
extends BlockEntityRenderer<OtisSeries3Button1.BlockEntity>
implements DirectionHelper,
IGui,
IBlock {
    private final Identifier BUTTON_TEXTURE = new Identifier("yte", "textures/block/otis_s3_button_1.png");
    private final Identifier ARROW_TEXTURE = new Identifier("yte", "textures/block/otis_s3_button_1_arrow.png");
    private final Identifier BUTTON_LIGHT_TEXTURE = new Identifier("yte", "textures/block/otis_s3_button_1_light.png");

    public RenderOtisSeries3Button1(BlockEntityRenderer.Argument dispatcher) {
        super(dispatcher);
    }

    public void render(OtisSeries3Button1.BlockEntity blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        DefaultButtonsKeyMapping keyMapping = blockEntity.getKeyMapping();
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        LiftButtonsBase.LiftButtonDescriptor buttonDescriptor = new LiftButtonsBase.LiftButtonDescriptor(false, false);
        StoredMatrixTransformations storedMatrixTransformations1 = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        storedMatrixTransformations1.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, (double)0.475f);
        });
        LinearLayout parentLayout = new LinearLayout(true);
        parentLayout.setBasicsAttributes(world, blockPos);
        parentLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        parentLayout.setParentDimensions(0.084375f, 0.2328125f);
        parentLayout.setPosition(-0.0405f, 0.05625f);
        parentLayout.setWidth(LayoutSize.MATCH_PARENT);
        parentLayout.setHeight(LayoutSize.MATCH_PARENT);
        LinearLayout buttonContainer = new LinearLayout(true);
        buttonContainer.setBasicsAttributes(world, blockPos);
        buttonContainer.setWidth(LayoutSize.WRAP_CONTENT);
        buttonContainer.setHeight(LayoutSize.WRAP_CONTENT);
        buttonContainer.setMargin(0.00625f, 0.028125f, 0.0f, 0.0f);
        LinearLayout upButtonGroup = new LinearLayout(false);
        upButtonGroup.setBasicsAttributes(world, blockPos);
        upButtonGroup.setStoredMatrixTransformations(storedMatrixTransformations1);
        upButtonGroup.setWidth(LayoutSize.WRAP_CONTENT);
        upButtonGroup.setHeight(LayoutSize.WRAP_CONTENT);
        upButtonGroup.setGravity(Gravity.CENTER_HORIZONTAL);
        LinearLayout downButtonGroup = new LinearLayout(false);
        downButtonGroup.setBasicsAttributes(world, blockPos);
        downButtonGroup.setStoredMatrixTransformations(storedMatrixTransformations1);
        downButtonGroup.setWidth(LayoutSize.WRAP_CONTENT);
        downButtonGroup.setHeight(LayoutSize.WRAP_CONTENT);
        downButtonGroup.setGravity(Gravity.CENTER_HORIZONTAL);
        FrameLayout upButtonLightGroup = new FrameLayout();
        upButtonLightGroup.setBasicsAttributes(world, blockPos);
        upButtonLightGroup.setWidth(LayoutSize.WRAP_CONTENT);
        upButtonLightGroup.setHeight(LayoutSize.WRAP_CONTENT);
        upButtonLightGroup.setGravity(Gravity.END);
        FrameLayout downButtonLightGroup = new FrameLayout();
        downButtonLightGroup.setBasicsAttributes(world, blockPos);
        downButtonLightGroup.setWidth(LayoutSize.WRAP_CONTENT);
        downButtonLightGroup.setHeight(LayoutSize.WRAP_CONTENT);
        downButtonLightGroup.setGravity(Gravity.END);
        ImageView buttonUpArrow = new ImageView();
        buttonUpArrow.setBasicsAttributes(world, blockPos);
        buttonUpArrow.setTexture(this.ARROW_TEXTURE);
        buttonUpArrow.setDimension(0.0375f);
        buttonUpArrow.setGravity(Gravity.START);
        buttonUpArrow.setLight(light);
        ImageView buttonDownArrow = new ImageView();
        buttonDownArrow.setBasicsAttributes(world, blockPos);
        buttonDownArrow.setTexture(this.ARROW_TEXTURE);
        buttonDownArrow.setDimension(0.0375f);
        buttonDownArrow.setGravity(Gravity.START);
        buttonDownArrow.setLight(light);
        buttonDownArrow.setFlip(false, true);
        ImageView buttonUpBackground = new ImageView();
        buttonUpBackground.setBasicsAttributes(world, blockPos);
        buttonUpBackground.setTexture(this.BUTTON_TEXTURE);
        buttonUpBackground.setDimension(0.0375f);
        buttonUpBackground.setGravity(Gravity.CENTER);
        buttonUpBackground.setLight(light);
        ImageView buttonDownBackground = new ImageView();
        buttonDownBackground.setBasicsAttributes(world, blockPos);
        buttonDownBackground.setTexture(this.BUTTON_TEXTURE);
        buttonDownBackground.setDimension(0.0375f);
        buttonDownBackground.setGravity(Gravity.CENTER);
        buttonDownBackground.setLight(light);
        ButtonView buttonUpLight = new ButtonView();
        buttonUpLight.setId("up");
        buttonUpLight.setBasicsAttributes(world, blockPos, keyMapping);
        buttonUpLight.setTexture(this.BUTTON_LIGHT_TEXTURE);
        buttonUpLight.setDimension(0.0375f);
        buttonUpLight.setGravity(Gravity.CENTER);
        buttonUpLight.setLight(light);
        buttonUpLight.setDefaultColor(-15658735);
        buttonUpLight.setHoverColor(-3342388);
        buttonUpLight.setPressedColor(-10027162);
        ButtonView buttonDownLight = new ButtonView();
        buttonDownLight.setId("down");
        buttonDownLight.setBasicsAttributes(world, blockPos, keyMapping);
        buttonDownLight.setTexture(this.BUTTON_LIGHT_TEXTURE);
        buttonDownLight.setDimension(0.0375f);
        buttonDownLight.setGravity(Gravity.CENTER);
        buttonDownLight.setLight(light);
        buttonDownLight.setDefaultColor(-15658735);
        buttonDownLight.setHoverColor(-26215);
        buttonDownLight.setPressedColor(-65536);
        LineComponent line = new LineComponent();
        line.setBasicsAttributes(world, blockPos);
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        blockEntity.forEachTrackPosition(trackPosition -> {
            line.RenderLine(holdingLinker, (BlockPos)trackPosition);
            OtisSeries3Button1.hasButtonsClient(trackPosition, buttonDescriptor, (floorIndex, lift) -> {
                sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift));
                ObjectArraySet instructionDirections = lift.hasInstruction(floorIndex);
                instructionDirections.forEach(liftDirection -> {
                    switch (liftDirection) {
                        case DOWN: {
                            buttonDownLight.activate();
                            break;
                        }
                        case UP: {
                            buttonUpLight.activate();
                        }
                    }
                });
            });
        });
        upButtonLightGroup.addChild(buttonUpBackground);
        upButtonLightGroup.addChild(buttonUpLight);
        downButtonLightGroup.addChild(buttonDownBackground);
        downButtonLightGroup.addChild(buttonDownLight);
        if (buttonDescriptor.hasUpButton()) {
            upButtonGroup.addChild(buttonUpArrow);
            upButtonGroup.addChild(upButtonLightGroup);
            buttonContainer.addChild(upButtonGroup);
        }
        if (buttonDescriptor.hasDownButton()) {
            if (buttonDescriptor.hasUpButton()) {
                downButtonGroup.setMargin(0.0f, 0.021875f, 0.0f, 0.0f);
            }
            downButtonGroup.addChild(buttonDownArrow);
            downButtonGroup.addChild(downButtonLightGroup);
            buttonContainer.addChild(downButtonGroup);
        }
        parentLayout.addChild(buttonContainer);
        parentLayout.render();
    }
}

