/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import java.util.Comparator;
import net.minecraft.core.Vec3i;
import org.mtr.core.data.Lift;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.OtisSeries1Screen;
import top.xfunny.mod.client.resource.FontList;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.LiftFloorDisplayView;
import top.xfunny.mod.client.view.LineComponent;
import top.xfunny.mod.client.view.TextView;
import top.xfunny.mod.client.view.view_group.FrameLayout;
import top.xfunny.mod.client.view.view_group.LinearLayout;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;

public class RenderOtisSeries1Screen
extends BlockEntityRenderer<OtisSeries1Screen.BlockEntity>
implements DirectionHelper,
IGui,
IBlock {
    private final boolean isOdd;

    public RenderOtisSeries1Screen(BlockEntityRenderer.Argument dispatcher, Boolean isOdd) {
        super(dispatcher);
        this.isOdd = isOdd;
    }

    public void render(OtisSeries1Screen.BlockEntity blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        StoredMatrixTransformations storedMatrixTransformations1 = storedMatrixTransformations.copy();
        storedMatrixTransformations1.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, (double)0.434375f);
        });
        FrameLayout parentLayout = new FrameLayout();
        parentLayout.setBasicsAttributes(world, blockPos);
        parentLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        parentLayout.setParentDimensions(0.3f, 0.40625f);
        parentLayout.setPosition(-0.15f, 0.046875f);
        parentLayout.setWidth(LayoutSize.MATCH_PARENT);
        parentLayout.setHeight(LayoutSize.MATCH_PARENT);
        LinearLayout backgroundLayout = new LinearLayout(false);
        backgroundLayout.setBasicsAttributes(world, blockPos);
        backgroundLayout.setWidth(LayoutSize.WRAP_CONTENT);
        backgroundLayout.setHeight(LayoutSize.WRAP_CONTENT);
        backgroundLayout.setGravity(Gravity.CENTER);
        backgroundLayout.setBackgroundColor(-16777216);
        LineComponent line = new LineComponent();
        line.setBasicsAttributes(world, blockPos);
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        blockEntity.forEachTrackPosition(trackPosition -> {
            line.RenderLine(holdingLinker, (BlockPos)trackPosition);
            OtisSeries1Screen.LiftCheck(trackPosition, (floorIndex, lift) -> sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift)));
        });
        sortedPositionsAndLifts.sort(Comparator.comparingInt(sortedPositionAndLift -> blockPos.getManhattanDistance(new Vector3i((Vec3i)((BlockPos)sortedPositionAndLift.left()).data))));
        if (!sortedPositionsAndLifts.isEmpty()) {
            boolean count = true;
            for (int i = 0; i < 1; ++i) {
                LiftFloorDisplayView liftFloorDisplayView = new LiftFloorDisplayView();
                liftFloorDisplayView.setBasicsAttributes(world, blockPos, (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), FontList.instance.getFont("otis_series1"), 4.0f, -14838465);
                liftFloorDisplayView.setTextureId("otis_series1_screen");
                liftFloorDisplayView.setWidth(0.175f);
                liftFloorDisplayView.setHeight(0.25f);
                liftFloorDisplayView.setMargin(0.0f, 0.0f, 0.05f, 0.0f);
                liftFloorDisplayView.setTextAlign(TextView.HorizontalTextAlign.RIGHT);
                liftFloorDisplayView.setDisplayLength(2, 0.0f);
                backgroundLayout.addChild(liftFloorDisplayView);
            }
        }
        parentLayout.addChild(backgroundLayout);
        parentLayout.render();
    }
}

