/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import java.util.Comparator;
import net.minecraft.core.Vec3i;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Init;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.RenderLifts;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.MitsubishiNexWayScreen1Even;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.client.resource.FontList;
import top.xfunny.mod.client.view.ButtonView;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.ImageView;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.LiftFloorDisplayView;
import top.xfunny.mod.client.view.LineComponent;
import top.xfunny.mod.client.view.TextView;
import top.xfunny.mod.client.view.view_group.FrameLayout;
import top.xfunny.mod.client.view.view_group.LinearLayout;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;
import top.xfunny.mod.util.ClientGetLiftDetails;

public class RenderMitsubishiNexWayScreen1<T extends LiftButtonsBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements DirectionHelper,
IGui,
IBlock {
    private static final int PRESSED_COLOR = -73303;
    private static final int DEFAULT_COLOR = -1;
    private static final Identifier BUTTON_TEXTURE = new Identifier("yte", "textures/block/mitsubishi_lantern_light_1.png");
    private static final Identifier ARROW_TEXTURE = new Identifier("yte", "textures/block/mitsubishi_lantern_light_1_arrow.png");
    private final boolean isOdd;

    public RenderMitsubishiNexWayScreen1(BlockEntityRenderer.Argument dispatcher, Boolean isOdd) {
        super(dispatcher);
        this.isOdd = isOdd;
    }

    public void render(T blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        LiftButtonsBase.LiftButtonDescriptor buttonDescriptor = new LiftButtonsBase.LiftButtonDescriptor(false, false);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        StoredMatrixTransformations storedMatrixTransformations1 = storedMatrixTransformations.copy();
        storedMatrixTransformations1.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, (double)0.490625f);
        });
        FrameLayout parentLayout = new FrameLayout();
        parentLayout.setBasicsAttributes(world, blockPos);
        parentLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        parentLayout.setParentDimensions(0.96875f, 0.28125f);
        parentLayout.setPosition(this.isOdd ? -0.484375f : -0.984375f, 0.5625f);
        parentLayout.setWidth(LayoutSize.MATCH_PARENT);
        parentLayout.setHeight(LayoutSize.MATCH_PARENT);
        LinearLayout linearLayout = new LinearLayout(false);
        linearLayout.setBasicsAttributes(world, blockPos);
        linearLayout.setHeight(LayoutSize.WRAP_CONTENT);
        linearLayout.setWidth(LayoutSize.WRAP_CONTENT);
        linearLayout.setGravity(Gravity.CENTER);
        FrameLayout screenLayout = new FrameLayout();
        screenLayout.setBasicsAttributes(world, blockPos);
        screenLayout.setWidth(LayoutSize.WRAP_CONTENT);
        screenLayout.setHeight(LayoutSize.WRAP_CONTENT);
        screenLayout.setGravity(Gravity.CENTER_VERTICAL);
        screenLayout.setMargin(0.0f, 0.0f, 0.14375f, 0.0f);
        FrameLayout lanternGroupLeft = new FrameLayout();
        lanternGroupLeft.setBasicsAttributes(world, blockPos);
        lanternGroupLeft.setWidth(LayoutSize.WRAP_CONTENT);
        lanternGroupLeft.setHeight(LayoutSize.WRAP_CONTENT);
        lanternGroupLeft.setGravity(Gravity.CENTER_VERTICAL);
        lanternGroupLeft.setMargin(0.0f, 0.0f, 0.14375f, 0.0f);
        FrameLayout lanternGroupRight = new FrameLayout();
        lanternGroupRight.setBasicsAttributes(world, blockPos);
        lanternGroupRight.setWidth(LayoutSize.WRAP_CONTENT);
        lanternGroupRight.setHeight(LayoutSize.WRAP_CONTENT);
        lanternGroupRight.setGravity(Gravity.CENTER_VERTICAL);
        ImageView lanternArrowUpLeft = new ImageView();
        lanternArrowUpLeft.setBasicsAttributes(world, blockPos);
        lanternArrowUpLeft.setTexture(ARROW_TEXTURE);
        lanternArrowUpLeft.setDimension(0.171875f);
        lanternArrowUpLeft.setGravity(Gravity.CENTER);
        lanternArrowUpLeft.setLight(light);
        ImageView lanternArrowUpRight = new ImageView();
        lanternArrowUpRight.setBasicsAttributes(world, blockPos);
        lanternArrowUpRight.setTexture(ARROW_TEXTURE);
        lanternArrowUpRight.setDimension(0.171875f);
        lanternArrowUpRight.setGravity(Gravity.CENTER);
        lanternArrowUpRight.setLight(light);
        ImageView lanternArrowDownLeft = new ImageView();
        lanternArrowDownLeft.setBasicsAttributes(world, blockPos);
        lanternArrowDownLeft.setTexture(ARROW_TEXTURE);
        lanternArrowDownLeft.setDimension(0.171875f);
        lanternArrowDownLeft.setGravity(Gravity.CENTER);
        lanternArrowDownLeft.setLight(light);
        lanternArrowDownLeft.setFlip(false, true);
        ImageView lanternArrowDownRight = new ImageView();
        lanternArrowDownRight.setBasicsAttributes(world, blockPos);
        lanternArrowDownRight.setTexture(ARROW_TEXTURE);
        lanternArrowDownRight.setDimension(0.171875f);
        lanternArrowDownRight.setGravity(Gravity.CENTER);
        lanternArrowDownRight.setLight(light);
        lanternArrowDownRight.setFlip(false, true);
        ButtonView downLanternLeft = new ButtonView();
        downLanternLeft.setBasicsAttributes(world, blockPos);
        downLanternLeft.setTexture(BUTTON_TEXTURE);
        downLanternLeft.setDimension(0.171875f);
        downLanternLeft.setGravity(Gravity.CENTER);
        downLanternLeft.setLight(light);
        downLanternLeft.setDefaultColor(-1);
        downLanternLeft.setPressedColor(-73303);
        ButtonView downLanternRight = new ButtonView();
        downLanternRight.setBasicsAttributes(world, blockPos);
        downLanternRight.setTexture(BUTTON_TEXTURE);
        downLanternRight.setDimension(0.171875f);
        downLanternRight.setGravity(Gravity.CENTER);
        downLanternRight.setLight(light);
        downLanternRight.setDefaultColor(-1);
        downLanternRight.setPressedColor(-73303);
        ButtonView upLanternLeft = new ButtonView();
        upLanternLeft.setBasicsAttributes(world, blockPos);
        upLanternLeft.setTexture(BUTTON_TEXTURE);
        upLanternLeft.setDimension(0.171875f);
        upLanternLeft.setGravity(Gravity.CENTER);
        upLanternLeft.setLight(light);
        upLanternLeft.setDefaultColor(-1);
        upLanternLeft.setPressedColor(-73303);
        ButtonView upLanternRight = new ButtonView();
        upLanternRight.setBasicsAttributes(world, blockPos);
        upLanternRight.setTexture(BUTTON_TEXTURE);
        upLanternRight.setDimension(0.171875f);
        upLanternRight.setGravity(Gravity.CENTER);
        upLanternRight.setLight(light);
        upLanternRight.setDefaultColor(-1);
        upLanternRight.setPressedColor(-73303);
        LineComponent line = new LineComponent();
        line.setBasicsAttributes(world, blockPos);
        LineComponent buttonLine = new LineComponent();
        buttonLine.setBasicsAttributes(world, blockPos);
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        ((LiftButtonsBase.BlockEntityBase)blockEntity).forEachTrackPosition(trackPosition -> {
            line.RenderLine(holdingLinker, (BlockPos)trackPosition);
            MitsubishiNexWayScreen1Even.hasButtonsClient(trackPosition, buttonDescriptor, (floorIndex, lift) -> {
                sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift));
                LiftDirection pressedButtonDirection = blockEntity.getPressedButtonDirection();
                ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = ClientGetLiftDetails.getLiftDetails(world, lift, Init.positionToBlockPos((Position)lift.getCurrentFloor().getPosition()));
                String floorNumber = (String)((ObjectObjectImmutablePair)liftDetails.right()).left();
                String currentFloorNumber = (String)((ObjectObjectImmutablePair)RenderLifts.getLiftDetails((World)world, (Lift)lift, (BlockPos)trackPosition).right()).left();
                ObjectArraySet instructionDirections = lift.hasInstruction(floorIndex);
                if (instructionDirections.isEmpty() && pressedButtonDirection != null && lift.getDoorValue() != 0.0f && floorNumber.equals(currentFloorNumber)) {
                    switch (pressedButtonDirection) {
                        case DOWN: {
                            downLanternLeft.activate();
                            downLanternRight.activate();
                            break;
                        }
                        case UP: {
                            upLanternLeft.activate();
                            upLanternRight.activate();
                        }
                    }
                }
                instructionDirections.forEach(liftDirection -> {
                    if (lift.getDoorValue() != 0.0f && floorNumber.equals(currentFloorNumber)) {
                        if (liftDirection == LiftDirection.NONE) {
                            if (pressedButtonDirection != null) {
                                switch (pressedButtonDirection) {
                                    case DOWN: {
                                        downLanternLeft.activate();
                                        downLanternRight.activate();
                                        break;
                                    }
                                    case UP: {
                                        upLanternLeft.activate();
                                        upLanternRight.activate();
                                    }
                                }
                            }
                        } else {
                            switch (liftDirection) {
                                case DOWN: {
                                    downLanternLeft.activate();
                                    downLanternRight.activate();
                                    break;
                                }
                                case UP: {
                                    upLanternLeft.activate();
                                    upLanternRight.activate();
                                }
                            }
                        }
                    }
                });
            });
        });
        sortedPositionsAndLifts.sort(Comparator.comparingInt(sortedPositionAndLift -> blockPos.getManhattanDistance(new Vector3i((Vec3i)((BlockPos)sortedPositionAndLift.left()).data))));
        if (!sortedPositionsAndLifts.isEmpty()) {
            boolean count = true;
            for (int i = 0; i < 1; ++i) {
                Lift lift = (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right();
                ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = ClientGetLiftDetails.getLiftDetails(world, lift, Init.positionToBlockPos((Position)lift.getCurrentFloor().getPosition()));
                String floorNumber = (String)((ObjectObjectImmutablePair)liftDetails.right()).left();
                LiftFloorDisplayView liftFloorDisplayView = new LiftFloorDisplayView();
                liftFloorDisplayView.setBasicsAttributes(world, blockPos, (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), FontList.instance.getFont("mitsubishi_modern"), 11.0f, -361948);
                liftFloorDisplayView.setTextureId("mitsubishi_nexway_screen_1");
                liftFloorDisplayView.setWidth(0.16875f);
                liftFloorDisplayView.setHeight(0.125f);
                liftFloorDisplayView.setGravity(Gravity.CENTER);
                liftFloorDisplayView.setTextAlign(TextView.HorizontalTextAlign.CENTER);
                liftFloorDisplayView.setMargin(0.025f, 0.0f, 0.025f, 0.0f);
                liftFloorDisplayView.addStoredMatrixTransformations(graphicsHolder -> graphicsHolder.translate(0.0, 0.0, (double)-0.003125f));
                if (liftFloorDisplayView.getTextLength() >= 3) {
                    liftFloorDisplayView.setBasicsAttributes(world, blockPos, (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), FontList.instance.getFont(floorNumber.matches(".*[A-Z].*") ? "mitsubishi_small_regular" : "mitsubishi_small_sht"), 11.0f, -361948);
                    liftFloorDisplayView.setAdaptMode(TextView.AdaptMode.FORCE_FIT_WIDTH);
                    liftFloorDisplayView.setMargin(0.0375f, 0.0f, 0.0125f, 0.0f);
                } else {
                    liftFloorDisplayView.setAdaptMode(TextView.AdaptMode.ASPECT_FILL);
                }
                screenLayout.addChild(liftFloorDisplayView);
            }
        }
        ((LiftButtonsBase.BlockEntityBase)blockEntity).forEachLiftButtonPosition(buttonPosition -> buttonLine.RenderLine(holdingLinker, (BlockPos)buttonPosition, true));
        if (buttonDescriptor.hasDownButton() && buttonDescriptor.hasUpButton()) {
            lanternGroupLeft.addChild(downLanternLeft);
            lanternGroupLeft.addChild(lanternArrowDownLeft);
            lanternGroupRight.addChild(upLanternRight);
            lanternGroupRight.addChild(lanternArrowUpRight);
            linearLayout.addChild(lanternGroupLeft);
            linearLayout.addChild(screenLayout);
            linearLayout.addChild(lanternGroupRight);
        } else if (buttonDescriptor.hasDownButton()) {
            lanternGroupLeft.addChild(downLanternLeft);
            lanternGroupLeft.addChild(lanternArrowDownLeft);
            lanternGroupRight.addChild(downLanternRight);
            lanternGroupRight.addChild(lanternArrowDownRight);
            linearLayout.addChild(lanternGroupLeft);
            linearLayout.addChild(screenLayout);
            linearLayout.addChild(lanternGroupRight);
        } else if (buttonDescriptor.hasUpButton()) {
            lanternGroupLeft.addChild(upLanternLeft);
            lanternGroupLeft.addChild(lanternArrowUpLeft);
            lanternGroupRight.addChild(upLanternRight);
            lanternGroupRight.addChild(lanternArrowUpRight);
            linearLayout.addChild(lanternGroupLeft);
            linearLayout.addChild(screenLayout);
            linearLayout.addChild(lanternGroupRight);
        }
        parentLayout.addChild(linearLayout);
        parentLayout.render();
    }
}

