/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import java.util.Comparator;
import net.minecraft.core.Vec3i;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.data.Position;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArraySet;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.PlayerHelper;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.Init;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.RenderLifts;
import org.mtr.mod.render.StoredMatrixTransformations;
import top.xfunny.mod.block.MitsubishiMPVFButton1;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.client.resource.FontList;
import top.xfunny.mod.client.view.ButtonView;
import top.xfunny.mod.client.view.Gravity;
import top.xfunny.mod.client.view.LayoutSize;
import top.xfunny.mod.client.view.LiftFloorDisplayView;
import top.xfunny.mod.client.view.LineComponent;
import top.xfunny.mod.client.view.TextView;
import top.xfunny.mod.client.view.view_group.FrameLayout;
import top.xfunny.mod.client.view.view_group.LinearLayout;
import top.xfunny.mod.item.YteGroupLiftButtonsLinker;
import top.xfunny.mod.item.YteLiftButtonsLinker;
import top.xfunny.mod.util.ClientGetLiftDetails;

public class RenderMitsubishiMPVFScreen1Vertical<T extends LiftButtonsBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements DirectionHelper,
IGui,
IBlock {
    private static final int PRESSED_COLOR = -13312;
    private static final int DEFAULT_COLOR = -1;
    private static final Identifier BUTTON_TEXTURE = new Identifier("yte", "textures/block/mitsubishi_mpvf_lantern_1.png");
    private final boolean isOdd;

    public RenderMitsubishiMPVFScreen1Vertical(BlockEntityRenderer.Argument dispatcher, Boolean isOdd) {
        super(dispatcher);
        this.isOdd = isOdd;
    }

    public void render(T blockEntity, float tickDelta, GraphicsHolder graphicsHolder1, int light, int overlay) {
        World world = blockEntity.getWorld2();
        if (world == null) {
            return;
        }
        ClientPlayerEntity clientPlayerEntity = MinecraftClient.getInstance().getPlayerMapped();
        if (clientPlayerEntity == null) {
            return;
        }
        boolean holdingLinker = PlayerHelper.isHolding((PlayerEntity)PlayerEntity.cast((HolderBase)clientPlayerEntity), item -> item.data instanceof YteLiftButtonsLinker || item.data instanceof YteGroupLiftButtonsLinker);
        BlockPos blockPos = blockEntity.getPos2();
        BlockState blockState = world.getBlockState(blockPos);
        Direction facing = IBlock.getStatePropertySafe((BlockState)blockState, (DirectionProperty)FACING);
        LiftButtonsBase.LiftButtonDescriptor buttonDescriptor = new LiftButtonsBase.LiftButtonDescriptor(false, false);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
        StoredMatrixTransformations storedMatrixTransformations1 = storedMatrixTransformations.copy();
        storedMatrixTransformations1.add(graphicsHolder -> {
            graphicsHolder.rotateYDegrees(-facing.asRotation());
            graphicsHolder.translate(0.0, 0.0, 0.4937499761581421);
        });
        FrameLayout parentLayout = new FrameLayout();
        parentLayout.setBasicsAttributes(world, blockEntity.getPos2());
        parentLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        parentLayout.setParentDimensions(0.1140625f, 0.2015625f);
        parentLayout.setPosition(this.isOdd ? -0.05703125f : -0.5570313f, 0.2640625f);
        parentLayout.setWidth(LayoutSize.MATCH_PARENT);
        parentLayout.setHeight(LayoutSize.MATCH_PARENT);
        LinearLayout linearLayout = new LinearLayout(true);
        linearLayout.setBasicsAttributes(world, blockEntity.getPos2());
        linearLayout.setHeight(LayoutSize.WRAP_CONTENT);
        linearLayout.setWidth(LayoutSize.WRAP_CONTENT);
        linearLayout.setGravity(Gravity.CENTER);
        FrameLayout screenLayout = new FrameLayout();
        screenLayout.setBasicsAttributes(world, blockEntity.getPos2());
        screenLayout.setStoredMatrixTransformations(storedMatrixTransformations1);
        screenLayout.setParentDimensions(0.1140625f, 0.0625f);
        screenLayout.setPosition(this.isOdd ? -0.05703125f : -0.5570313f, 0.146875f);
        screenLayout.setWidth(LayoutSize.MATCH_PARENT);
        screenLayout.setHeight(LayoutSize.MATCH_PARENT);
        screenLayout.setGravity(Gravity.CENTER_HORIZONTAL);
        ButtonView upLantern = new ButtonView();
        upLantern.setBasicsAttributes(world, blockEntity.getPos2());
        upLantern.setTexture(BUTTON_TEXTURE);
        upLantern.setDimension(0.09375f);
        upLantern.setGravity(Gravity.CENTER_HORIZONTAL);
        upLantern.setLight(light);
        upLantern.setDefaultColor(-1);
        upLantern.setPressedColor(-13312);
        ButtonView downLantern = new ButtonView();
        downLantern.setBasicsAttributes(world, blockEntity.getPos2());
        downLantern.setTexture(BUTTON_TEXTURE);
        downLantern.setDimension(0.09375f);
        downLantern.setGravity(Gravity.CENTER_HORIZONTAL);
        downLantern.setLight(light);
        downLantern.setDefaultColor(-1);
        downLantern.setPressedColor(-13312);
        downLantern.setFlip(false, true);
        LineComponent line = new LineComponent();
        line.setBasicsAttributes(world, blockEntity.getPos2());
        LineComponent buttonLine = new LineComponent();
        buttonLine.setBasicsAttributes(world, blockEntity.getPos2());
        ObjectArrayList sortedPositionsAndLifts = new ObjectArrayList();
        ((LiftButtonsBase.BlockEntityBase)blockEntity).forEachTrackPosition(trackPosition -> {
            line.RenderLine(holdingLinker, (BlockPos)trackPosition);
            MitsubishiMPVFButton1.hasButtonsClient(trackPosition, buttonDescriptor, (floorIndex, lift) -> {
                sortedPositionsAndLifts.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)lift));
                LiftDirection pressedButtonDirection = blockEntity.getPressedButtonDirection();
                ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = ClientGetLiftDetails.getLiftDetails(world, lift, Init.positionToBlockPos((Position)lift.getCurrentFloor().getPosition()));
                String floorNumber = (String)((ObjectObjectImmutablePair)liftDetails.right()).left();
                String currentFloorNumber = (String)((ObjectObjectImmutablePair)RenderLifts.getLiftDetails((World)world, (Lift)lift, (BlockPos)trackPosition).right()).left();
                ObjectArraySet instructionDirections = lift.hasInstruction(floorIndex);
                if (instructionDirections.isEmpty() && pressedButtonDirection != null && lift.getDoorValue() != 0.0f && floorNumber.equals(currentFloorNumber)) {
                    switch (pressedButtonDirection) {
                        case DOWN: {
                            downLantern.activate();
                            break;
                        }
                        case UP: {
                            upLantern.activate();
                        }
                    }
                }
                instructionDirections.forEach(liftDirection -> {
                    if (lift.getDoorValue() != 0.0f && floorNumber.equals(currentFloorNumber)) {
                        if (liftDirection == LiftDirection.NONE) {
                            if (pressedButtonDirection != null) {
                                switch (pressedButtonDirection) {
                                    case DOWN: {
                                        downLantern.activate();
                                        break;
                                    }
                                    case UP: {
                                        upLantern.activate();
                                    }
                                }
                            }
                        } else {
                            switch (liftDirection) {
                                case DOWN: {
                                    downLantern.activate();
                                    break;
                                }
                                case UP: {
                                    upLantern.activate();
                                }
                            }
                        }
                    }
                });
            });
        });
        sortedPositionsAndLifts.sort(Comparator.comparingInt(sortedPositionAndLift -> blockEntity.getPos2().getManhattanDistance(new Vector3i((Vec3i)((BlockPos)sortedPositionAndLift.left()).data))));
        if (!sortedPositionsAndLifts.isEmpty()) {
            boolean count = true;
            for (int i = 0; i < 1; ++i) {
                LiftFloorDisplayView liftFloorDisplayView = new LiftFloorDisplayView();
                liftFloorDisplayView.setBasicsAttributes(world, blockEntity.getPos2(), (Lift)((ObjectObjectImmutablePair)sortedPositionsAndLifts.get(i)).right(), FontList.instance.getFont("mitsubishi_old_segmented_1"), 5.0f, -361948);
                liftFloorDisplayView.setDisplayLength(2, 0.0f);
                liftFloorDisplayView.setTextureId("mitsubishi_mpvf_screen_1");
                liftFloorDisplayView.setWidth(0.125f);
                liftFloorDisplayView.setHeight(0.125f);
                liftFloorDisplayView.setGravity(Gravity.CENTER);
                liftFloorDisplayView.setTextAlign(TextView.HorizontalTextAlign.RIGHT);
                screenLayout.addChild(liftFloorDisplayView);
            }
        }
        ((LiftButtonsBase.BlockEntityBase)blockEntity).forEachLiftButtonPosition(buttonPosition -> buttonLine.RenderLine(holdingLinker, (BlockPos)buttonPosition, true));
        if (buttonDescriptor.hasDownButton() && buttonDescriptor.hasUpButton()) {
            downLantern.setMargin(0.0f, 0.015625f, 0.0f, 0.0f);
            linearLayout.addChild(upLantern);
            linearLayout.addChild(downLantern);
        } else if (buttonDescriptor.hasDownButton()) {
            linearLayout.addChild(downLantern);
        } else if (buttonDescriptor.hasUpButton()) {
            linearLayout.addChild(upLantern);
        }
        parentLayout.addChild(linearLayout);
        parentLayout.render();
        screenLayout.render();
    }
}

