/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.render;

import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EntityAbstractMapping;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.EntityModelExtension;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.ModelPartExtension;
import org.mtr.mod.block.BlockPSDAPGDoorBase;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.data.IGui;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.StoredMatrixTransformations;

public class RenderLiftDoor<T extends BlockPSDAPGDoorBase.BlockEntityBase>
extends BlockEntityRenderer<T>
implements IGui,
IBlock {
    private static final ModelSingleCube MODEL_PSD_DOOR_LOCKED = new ModelSingleCube(6, 6, 5, 6, 1, 6, 6, 0);
    private static final ModelSingleCube MODEL_LIFT_LEFT = new ModelSingleCube(28, 18, 0, 0, 0, 12, 16, 2);
    private static final ModelSingleCube MODEL_LIFT_RIGHT = new ModelSingleCube(28, 18, 4, 0, 0, 12, 16, 2);
    private final int type;

    public RenderLiftDoor(BlockEntityRenderer.Argument dispatcher, int type) {
        super(dispatcher);
        this.type = type;
    }

    public void render(T entity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
        World world = entity.getWorld2();
        if (world == null) {
            return;
        }
        entity.tick(tickDelta);
        BlockPos blockPos = entity.getPos2();
        Direction facing = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (DirectionProperty)BlockPSDAPGDoorBase.FACING);
        boolean side = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (EnumProperty)BlockPSDAPGDoorBase.SIDE) == IBlock.EnumSide.RIGHT;
        boolean half = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (EnumProperty)BlockPSDAPGDoorBase.HALF) == IBlock.DoubleBlockHalf.UPPER;
        boolean unlocked = IBlock.getStatePropertySafe((World)world, (BlockPos)blockPos, (BooleanProperty)BlockPSDAPGDoorBase.UNLOCKED);
        double open = Math.min(entity.getDoorValue(), this.type >= 3 ? 0.75 : 1.0);
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)entity.getPos2().getX(), (double)entity.getPos2().getY(), 0.5 + (double)entity.getPos2().getZ());
        storedMatrixTransformations.add(graphicsHolderNew -> {
            graphicsHolderNew.rotateYDegrees(-facing.asRotation());
            graphicsHolderNew.rotateXDegrees(180.0f);
        });
        storedMatrixTransformations.add(matricesNew -> matricesNew.translate(open * (double)(side ? -1 : 1), 0.0, 0.0));
        switch (this.type) {
            case 0: 
            case 3: {
                MainRenderer.scheduleRender((Identifier)new Identifier(String.format("yte:textures/block/schindler_qks9_door_%s_%s_1.png", half ? "top" : "bottom", side ? "right" : "left")), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolderNew, offset);
                    (side ? MODEL_LIFT_RIGHT : MODEL_LIFT_LEFT).render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
                if (!half || unlocked) break;
                MainRenderer.scheduleRender((Identifier)new Identifier("mtr", "textures/block/sign/door_not_in_use.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolderNew, offset);
                    graphicsHolderNew.translate(side ? 0.125 : -0.125, 0.0, 0.0);
                    MODEL_PSD_DOOR_LOCKED.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
                break;
            }
            case 5: {
                MainRenderer.scheduleRender((Identifier)new Identifier(String.format("yte:textures/block/mitsubishi_nexway_door_%s_%s_1.png", half ? "top" : "bottom", side ? "right" : "left")), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolderNew, offset);
                    (side ? MODEL_LIFT_RIGHT : MODEL_LIFT_LEFT).render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
                if (!half || unlocked) break;
                MainRenderer.scheduleRender((Identifier)new Identifier("mtr", "textures/block/sign/door_not_in_use.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolderNew, offset);
                    graphicsHolderNew.translate(side ? 0.125 : -0.125, 0.0, 0.0);
                    MODEL_PSD_DOOR_LOCKED.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
                break;
            }
            case 6: {
                MainRenderer.scheduleRender((Identifier)new Identifier(String.format("yte:textures/block/kone_m_door_%s_%s_1.png", half ? "top" : "bottom", side ? "right" : "left")), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolderNew, offset);
                    (side ? MODEL_LIFT_RIGHT : MODEL_LIFT_LEFT).render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
                if (!half || unlocked) break;
                MainRenderer.scheduleRender((Identifier)new Identifier("mtr", "textures/block/sign/door_not_in_use.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolderNew, offset);
                    graphicsHolderNew.translate(side ? 0.125 : -0.125, 0.0, 0.0);
                    MODEL_PSD_DOOR_LOCKED.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
                break;
            }
            case 7: {
                MainRenderer.scheduleRender((Identifier)new Identifier(String.format("yte:textures/block/hitachi_b85_door_%s_%s_1.png", half ? "top" : "bottom", side ? "right" : "left")), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolderNew, offset);
                    (side ? MODEL_LIFT_RIGHT : MODEL_LIFT_LEFT).render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
                if (!half || unlocked) break;
                MainRenderer.scheduleRender((Identifier)new Identifier("mtr", "textures/block/sign/door_not_in_use.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolderNew, offset);
                    graphicsHolderNew.translate(side ? 0.125 : -0.125, 0.0, 0.0);
                    MODEL_PSD_DOOR_LOCKED.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
                break;
            }
            case 8: {
                MainRenderer.scheduleRender((Identifier)new Identifier(String.format("yte:textures/block/otis_e411_us_door_%s_%s_1.png", half ? "top" : "bottom", side ? "right" : "left")), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolderNew, offset);
                    (side ? MODEL_LIFT_RIGHT : MODEL_LIFT_LEFT).render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
                if (!half || unlocked) break;
                MainRenderer.scheduleRender((Identifier)new Identifier("mtr", "textures/block/sign/door_not_in_use.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.EXTERIOR, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolderNew, offset);
                    graphicsHolderNew.translate(side ? 0.125 : -0.125, 0.0, 0.0);
                    MODEL_PSD_DOOR_LOCKED.render((GraphicsHolder)graphicsHolderNew, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    graphicsHolderNew.pop();
                });
            }
        }
    }

    public boolean rendersOutsideBoundingBox2(T blockEntity) {
        return true;
    }

    private static class ModelSingleCube
    extends EntityModelExtension<EntityAbstractMapping> {
        private final ModelPartExtension cube = this.createModelPart();

        private ModelSingleCube(int textureWidth, int textureHeight, int x, int y, int z, int length, int height, int depth) {
            super(textureWidth, textureHeight);
            this.cube.setTextureUVOffset(0, 0).addCuboid((float)(x - 8), (float)(y - 16), (float)(z - 8), length, height, depth, 0.0f, false);
            this.buildModel();
        }

        public void render(GraphicsHolder graphicsHolder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.cube.render(graphicsHolder, 0.0f, 0.0f, 0.0f, packedLight, packedOverlay);
        }

        public void setAngles2(EntityAbstractMapping entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        }
    }
}

