/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.client.client_data;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mtr.core.data.Lift;
import org.mtr.mod.InitClient;
import top.xfunny.mixin.MixinLiftSchema;

public class LiftSpeed {
    private static final float UPDATE_INTERVAL_TICKS = 1.0f;
    private final Map<Long, Double> speedCache = new ConcurrentHashMap<Long, Double>();
    private final Map<Long, Float> tickCache = new ConcurrentHashMap<Long, Float>();
    private double rawSpeed;
    private float publicLatestGameTick = -1.0f;

    public double getSpeed(Lift lift) {
        float gameTick = InitClient.getGameTick();
        long liftId = lift.getId();
        float lastUpdateTick = this.tickCache.getOrDefault(liftId, Float.valueOf(0.0f)).floatValue();
        if (gameTick < this.publicLatestGameTick) {
            this.publicLatestGameTick = gameTick;
            this.speedCache.clear();
            this.tickCache.clear();
        }
        if (lastUpdateTick - this.publicLatestGameTick >= 1.0f) {
            this.publicLatestGameTick = gameTick;
        }
        if (gameTick - lastUpdateTick >= 1.0f) {
            this.rawSpeed = ((MixinLiftSchema)lift).getSpeed() * 1000.0;
            this.speedCache.put(liftId, this.rawSpeed);
            this.tickCache.put(liftId, Float.valueOf(gameTick));
        }
        return this.speedCache.getOrDefault(liftId, 0.0);
    }
}

