/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.block.base;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.core.data.Lift;
import org.mtr.core.data.LiftDirection;
import org.mtr.core.data.LiftInstruction;
import org.mtr.core.data.Position;
import org.mtr.core.operation.PressLift;
import org.mtr.core.tool.Vector;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import org.mtr.libraries.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.mtr.libraries.kotlin.Triple;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockEntity;
import org.mtr.mapping.holder.BlockEntityType;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.Blocks;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.CompoundTag;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.EnumProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.ItemStack;
import org.mtr.mapping.holder.LivingEntity;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.Vector3i;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockExtension;
import org.mtr.mapping.mapper.BlockHelper;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.DirectionHelper;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.IBlock;
import org.mtr.mod.client.MinecraftClientData;
import org.mtr.mod.item.ItemLiftRefresher;
import org.mtr.mod.packet.PacketPressLiftButton;
import top.xfunny.mixin.MixinLiftSchema;
import top.xfunny.mod.ButtonRegistry;
import top.xfunny.mod.Init;
import top.xfunny.mod.LiftFloorRegistry;
import top.xfunny.mod.LiftLanternController;
import top.xfunny.mod.block.base.LiftButtonsBase;
import top.xfunny.mod.keymapping.DefaultButtonsKeyMapping;
import top.xfunny.mod.util.GetLiftDetails;

public abstract class LiftDestinationDispatchTerminalBase
extends BlockExtension
implements DirectionHelper,
BlockWithEntity,
IBlock {
    public static final BooleanProperty UNLOCKED = BooleanProperty.of((String)"unlocked");
    private final boolean isOdd;

    public LiftDestinationDispatchTerminalBase(boolean isOdd) {
        super(BlockHelper.createBlockSettings((boolean)true, (boolean)true));
        this.isOdd = isOdd;
    }

    public static void hasButtonsClient(BlockPos trackPosition, FloorLiftCallback callback) {
        MinecraftClientData.getInstance().lifts.forEach(lift -> {
            int floorIndex = lift.getFloorIndex(Init.blockPosToPosition(trackPosition));
            if (floorIndex >= 0) {
                callback.accept(floorIndex, (Lift)lift);
            }
        });
    }

    @Nonnull
    public abstract ActionResult onUse2(BlockState var1, World var2, BlockPos var3, PlayerEntity var4, Hand var5, BlockHitResult var6);

    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction facing = ctx.getPlayerFacing();
        if (!this.isOdd) {
            return IBlock.isReplaceable((ItemPlacementContext)ctx, (Direction)facing.rotateYClockwise(), (int)2) ? this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)LiftDestinationDispatchTerminalBase.FACING.data), (Comparable)facing.data).with(new org.mtr.mapping.holder.Property((Property)LiftDestinationDispatchTerminalBase.SIDE.data), (Comparable)IBlock.EnumSide.LEFT) : null;
        }
        return this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)LiftDestinationDispatchTerminalBase.FACING.data), (Comparable)facing.data);
    }

    public void onPlaced2(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        if (!world.isClient()) {
            Direction facing = IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING);
            if (!this.isOdd) {
                world.setBlockState(pos.offset(facing.rotateYClockwise()), this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)LiftDestinationDispatchTerminalBase.FACING.data), (Comparable)facing.data).with(new org.mtr.mapping.holder.Property((Property)LiftDestinationDispatchTerminalBase.SIDE.data), (Comparable)IBlock.EnumSide.RIGHT), 3);
            }
            world.updateNeighbors(pos, Blocks.getAirMapped());
            state.updateNeighbors(new WorldAccess((LevelAccessor)world.data), pos, 3);
        }
    }

    public void onBreak2(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!this.isOdd) {
            if (IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)SIDE) == IBlock.EnumSide.RIGHT) {
                IBlock.onBreakCreative((World)world, (PlayerEntity)player, (BlockPos)pos.offset(IBlock.getSideDirection((BlockState)state)));
            } else if (IBlock.getStatePropertySafe((BlockState)state, (EnumProperty)SIDE) == IBlock.EnumSide.LEFT) {
                IBlock.onBreakCreative((World)world, (PlayerEntity)player, (BlockPos)pos.offset(IBlock.getSideDirection((BlockState)state)));
            }
        }
        super.onBreak2(world, pos, state, player);
    }

    @FunctionalInterface
    public static interface FloorLiftCallback {
        public void accept(int var1, Lift var2);
    }

    public static class BlockEntityBase
    extends BlockEntityExtension
    implements LiftFloorRegistry,
    ButtonRegistry,
    LiftLanternController {
        private static final String KEY_TRACK_FLOOR_POS = "track_floor_pos";
        private static final String KEY_LIFT_BUTTON_POSITIONS = "lift_button_position";
        private static final String KEY_SCREEN_ID = "screen_id";
        public final ObjectOpenHashSet<BlockPos> liftButtonPositions = new ObjectOpenHashSet();
        private final LinkedHashSet<BlockPos> trackPositions = new LinkedHashSet();
        public LiftDirection liftDirection = LiftDirection.NONE;
        public BlockPos selfPos;
        private DefaultButtonsKeyMapping keyMapping = new DefaultButtonsKeyMapping();
        private String screenId;
        private char liftIdentifier;

        public BlockEntityBase(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
            super(type, blockPos, blockState);
        }

        public DefaultButtonsKeyMapping getKeyMapping() {
            return this.keyMapping;
        }

        public void setKeyMapping(DefaultButtonsKeyMapping keyMapping) {
            this.keyMapping = keyMapping;
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.trackPositions.clear();
            this.liftButtonPositions.clear();
            for (long position : compoundTag.getLongArray(KEY_TRACK_FLOOR_POS)) {
                this.trackPositions.add(BlockPos.fromLong((long)position));
            }
            for (long position : compoundTag.getLongArray(KEY_LIFT_BUTTON_POSITIONS)) {
                this.liftButtonPositions.add((Object)BlockPos.fromLong((long)position));
            }
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            ArrayList trackPositionsList = new ArrayList();
            this.trackPositions.forEach(position -> trackPositionsList.add(position.asLong()));
            compoundTag.putLongArray(KEY_TRACK_FLOOR_POS, trackPositionsList);
            ArrayList liftButtonPositionsList = new ArrayList();
            this.liftButtonPositions.forEach(position -> liftButtonPositionsList.add(position.asLong()));
            compoundTag.putLongArray(KEY_LIFT_BUTTON_POSITIONS, liftButtonPositionsList);
            compoundTag.putString(KEY_SCREEN_ID, this.screenId);
        }

        @Override
        public void registerFloor(BlockPos selfPos, World world, BlockPos pos, boolean isAdd) {
            this.selfPos = selfPos;
            if (IBlock.getStatePropertySafe((World)world, (BlockPos)this.getPos2(), (EnumProperty)IBlock.SIDE) == IBlock.EnumSide.RIGHT) {
                BlockEntity blockEntity = world.getBlockEntity(this.getPos2().offset(IBlock.getStatePropertySafe((World)world, (BlockPos)this.getPos2(), (DirectionProperty)DirectionHelper.FACING).rotateYCounterclockwise()));
                if (blockEntity != null && blockEntity.data instanceof LiftButtonsBase.BlockEntityBase) {
                    ((LiftButtonsBase.BlockEntityBase)blockEntity.data).registerFloor(selfPos, world, pos, isAdd);
                }
            } else if (isAdd) {
                this.trackPositions.add(pos);
            } else {
                this.trackPositions.remove(pos);
            }
            this.markDirty2();
        }

        @Override
        public void registerButton(World world, BlockPos blockPos, boolean isAdd) {
            if (IBlock.getStatePropertySafe((World)world, (BlockPos)this.getPos2(), (EnumProperty)IBlock.SIDE) == IBlock.EnumSide.RIGHT) {
                BlockEntity blockEntity = world.getBlockEntity(this.getPos2().offset(IBlock.getStatePropertySafe((World)world, (BlockPos)this.getPos2(), (DirectionProperty)DirectionHelper.FACING).rotateYCounterclockwise()));
                if (blockEntity != null && blockEntity.data instanceof LiftButtonsBase.BlockEntityBase) {
                    ((LiftButtonsBase.BlockEntityBase)blockEntity.data).registerButton(world, blockPos, isAdd);
                }
            } else if (isAdd) {
                this.liftButtonPositions.add((Object)blockPos);
            } else {
                this.liftButtonPositions.remove((Object)blockPos);
            }
            this.markDirty2();
        }

        public void registerScreenId(String screenId) {
            this.screenId = screenId;
        }

        public String getScreenId() {
            return this.screenId;
        }

        public void forEachTrackPosition(Consumer<BlockPos> consumer) {
            this.trackPositions.forEach(consumer);
        }

        public String callLift(World world, BlockPos pos, String destination) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            BlockEntityBase data = (BlockEntityBase)blockEntity.data;
            ObjectArrayList trackPositionsAndChars = new ObjectArrayList();
            ObjectArrayList trackPositionsAndChars1 = new ObjectArrayList();
            ObjectArrayList trackPositionsAndChars2 = new ObjectArrayList();
            ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
            int[] minDistance = new int[]{Integer.MAX_VALUE};
            char[] minChar = new char[]{'?'};
            int[] counter = new int[]{0};
            BlockPos[] confirmTrackPosition = new BlockPos[1];
            Position[] destinationPosition = new Position[1];
            this.trackPositions.forEach(trackPosition -> {
                char currentChar = (char)(65 + counter[0]);
                trackPositionsAndChars.add((Object)new ObjectObjectImmutablePair(trackPosition, (Object)Character.valueOf(currentChar)));
                counter[0] = counter[0] + 1;
            });
            trackPositionsAndChars.forEach(trackPositionAndChar -> {
                BlockPos currentTrackPosition = (BlockPos)trackPositionAndChar.left();
                char currentChar = ((Character)trackPositionAndChar.right()).charValue();
                LiftDestinationDispatchTerminalBase.hasButtonsClient(currentTrackPosition, (floor, lift) -> {
                    if (this.locateFloor(world, lift, destination) != null) {
                        trackPositionsAndChars1.add((Object)new ObjectObjectImmutablePair((Object)currentTrackPosition, (Object)Character.valueOf(currentChar)));
                    }
                });
            });
            trackPositionsAndChars1.forEach(trackPositionAndChar1 -> {
                BlockPos currentTrackPosition = (BlockPos)trackPositionAndChar1.left();
                char currentChar = ((Character)trackPositionAndChar1.right()).charValue();
                LiftDestinationDispatchTerminalBase.hasButtonsClient(currentTrackPosition, (floor, lift) -> {
                    destinationPosition[0] = this.locateFloor(world, lift, destination);
                    ObjectObjectImmutablePair<LiftDirection, ObjectObjectImmutablePair<String, String>> liftDetails = GetLiftDetails.getLiftDetails(world, lift, org.mtr.mod.Init.positionToBlockPos((Position)lift.getCurrentFloor().getPosition()));
                    LiftDirection liftDirection = (LiftDirection)liftDetails.left();
                    int currentFloorNumber = lift.getFloorIndex(Init.blockPosToPosition(currentTrackPosition));
                    int destinationFloorNumber = lift.getFloorIndex(destinationPosition[0]);
                    String currentLiftFloor = (String)((ObjectObjectImmutablePair)liftDetails.right()).left();
                    if (!currentLiftFloor.isEmpty()) {
                        LiftDirection confirmLiftDirection;
                        Position currentLiftFloorPosition = this.locateFloor(world, lift, currentLiftFloor);
                        int currentLiftFloorNumber = lift.getFloorIndex(currentLiftFloorPosition);
                        this.liftDirection = confirmLiftDirection = this.determineDirection(currentFloorNumber, destinationFloorNumber);
                        if (liftDirection == LiftDirection.NONE) {
                            trackPositionsAndChars2.add((Object)new ObjectObjectImmutablePair((Object)currentTrackPosition, (Object)Character.valueOf(currentChar)));
                        } else if (liftDirection == confirmLiftDirection) {
                            if (confirmLiftDirection == LiftDirection.UP && currentLiftFloorNumber <= currentFloorNumber) {
                                trackPositionsAndChars2.add((Object)new ObjectObjectImmutablePair((Object)currentTrackPosition, (Object)Character.valueOf(currentChar)));
                            } else if (confirmLiftDirection == LiftDirection.DOWN && currentLiftFloorNumber >= currentFloorNumber) {
                                trackPositionsAndChars2.add((Object)new ObjectObjectImmutablePair((Object)currentTrackPosition, (Object)Character.valueOf(currentChar)));
                            }
                        }
                    }
                });
            });
            if (trackPositionsAndChars2.isEmpty()) {
                ArrayList<Triple> distanceGroup = new ArrayList<Triple>();
                trackPositionsAndChars1.forEach(trackPositionAndChar1 -> {
                    BlockPos currentTrackPosition = (BlockPos)trackPositionAndChar1.left();
                    char currentChar = ((Character)trackPositionAndChar1.right()).charValue();
                    LiftDestinationDispatchTerminalBase.hasButtonsClient(currentTrackPosition, (floor, lift) -> {
                        destinationPosition[0] = this.locateFloor(world, lift, destination);
                        int currentFloorNumber = lift.getFloorIndex(Init.blockPosToPosition(currentTrackPosition));
                        ObjectArrayList<LiftInstruction> instructions = ((MixinLiftSchema)lift).getInstructions();
                        LiftInstruction lastInstruction = instructions.isEmpty() ? null : (LiftInstruction)instructions.get(instructions.size() - 1);
                        int lastFloorNumber = lastInstruction.getFloor();
                        int distance = Math.abs(currentFloorNumber - lastFloorNumber);
                        distanceGroup.add(new Triple((Object)distance, (Object)Character.valueOf(currentChar), (Object)currentTrackPosition));
                    });
                });
                int[] minDistance1 = new int[]{Integer.MAX_VALUE};
                char[] char1 = new char[]{'?'};
                BlockPos[] confirmTrackPosition1 = new BlockPos[1];
                distanceGroup.forEach(distanceAndChar -> {
                    if ((Integer)distanceAndChar.getFirst() <= minDistance1[0]) {
                        minDistance1[0] = (Integer)distanceAndChar.getFirst();
                        char1[0] = ((Character)distanceAndChar.getSecond()).charValue();
                        confirmTrackPosition1[0] = (BlockPos)distanceAndChar.getThird();
                    }
                });
                trackPositionsAndChars2.add((Object)new ObjectObjectImmutablePair((Object)confirmTrackPosition1[0], (Object)Character.valueOf(char1[0])));
            }
            trackPositionsAndChars2.forEach(trackPositionAndChar2 -> {
                BlockPos currentTrackPosition = (BlockPos)trackPositionAndChar2.left();
                char currentChar = ((Character)trackPositionAndChar2.right()).charValue();
                if (currentTrackPosition != null) {
                    LiftDestinationDispatchTerminalBase.hasButtonsClient(currentTrackPosition, (floor, lift) -> {
                        Vector position = lift.getPosition((floorPosition1, floorPosition2) -> ItemLiftRefresher.findPath((World)new World((Level)world.data), (Position)floorPosition1, (Position)floorPosition2));
                        BlockPos liftPos = new BlockPos((int)position.x, (int)position.y, (int)position.z);
                        int distance = currentTrackPosition.getManhattanDistance(Vector3i.cast((HolderBase)liftPos));
                        if (distance < minDistance[0]) {
                            minDistance[0] = distance;
                            minChar[0] = currentChar;
                            this.liftIdentifier = currentChar;
                            confirmTrackPosition[0] = currentTrackPosition;
                            destinationPosition[0] = this.locateFloor(world, lift, destination);
                        }
                    });
                }
            });
            if (confirmTrackPosition[0] != null) {
                LiftDestinationDispatchTerminalBase.hasButtonsClient(confirmTrackPosition[0], (floor, lift) -> {
                    if (lift.getDoorValue() == 0.0f) {
                        PressLift pressLift = new PressLift();
                        pressLift.add(Init.blockPosToPosition(confirmTrackPosition[0]), data.liftDirection);
                        InitClient.REGISTRY_CLIENT.sendPacketToServer((PacketHandler)new PacketPressLiftButton(pressLift));
                    }
                });
                scheduler.schedule(() -> {
                    this.liftButtonPositions.forEach(lanternPos -> {
                        BlockEntity lanternBlockEntity = world.getBlockEntity(lanternPos);
                        if (lanternBlockEntity != null && lanternBlockEntity.data instanceof LiftButtonsBase.BlockEntityBase) {
                            LiftButtonsBase.BlockEntityBase lanternData = (LiftButtonsBase.BlockEntityBase)lanternBlockEntity.data;
                            lanternData.setPressedButtonDirection(data.liftDirection);
                        }
                    });
                    PressLift pressLift1 = new PressLift();
                    pressLift1.add(destinationPosition[0], data.liftDirection);
                    InitClient.REGISTRY_CLIENT.sendPacketToServer((PacketHandler)new PacketPressLiftButton(pressLift1));
                }, 2L, TimeUnit.SECONDS);
                return String.valueOf(this.liftIdentifier);
            }
            this.liftIdentifier = (char)63;
            return String.valueOf(this.liftIdentifier);
        }

        public Position locateFloor(World world, Lift lift, String destination) {
            Position[] foundPosition = new Position[1];
            lift.iterateFloors(liftFloor -> {
                String floorNumber = (String)((ObjectObjectImmutablePair)GetLiftDetails.getLiftDetails(world, lift, Init.positionToBlockPos(liftFloor.getPosition())).right()).left();
                if (destination.equals(floorNumber)) {
                    foundPosition[0] = liftFloor.getPosition();
                }
            });
            return foundPosition[0];
        }

        public String getLiftIdentifier() {
            return String.valueOf(this.liftIdentifier);
        }

        public LiftDirection determineDirection(int currentFloorNumber, int destinationFloorNumber) {
            if (currentFloorNumber < destinationFloorNumber) {
                return LiftDirection.UP;
            }
            if (currentFloorNumber > destinationFloorNumber) {
                return LiftDirection.DOWN;
            }
            return LiftDirection.NONE;
        }

        @Override
        public void forEachLiftButtonPosition(Consumer<BlockPos> consumer) {
            this.liftButtonPositions.forEach(consumer);
        }

        @Override
        public ObjectOpenHashSet<BlockPos> getLiftButtonPositions() {
            return this.liftButtonPositions;
        }

        @Override
        public LiftDirection getPressedButtonDirection() {
            return this.liftDirection;
        }
    }
}

