/*
 * Decompiled with CFR 0.152.
 */
package top.xfunny.mod.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.level.block.state.properties.Property;
import org.mtr.mapping.holder.ActionResult;
import org.mtr.mapping.holder.BlockHitResult;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.DirectionProperty;
import org.mtr.mapping.holder.Hand;
import org.mtr.mapping.holder.IntegerProperty;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.PlayerEntity;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mod.BlockEntityTypes;
import org.mtr.mod.block.BlockStationNameBase;
import org.mtr.mod.block.IBlock;

public class PRStationNameEntrance
extends BlockStationNameBase
implements IBlock {
    public static final IntegerProperty STYLE = IntegerProperty.of((String)"propagate_property", (int)0, (int)5);

    public PRStationNameEntrance(BlockSettings blockSettings) {
        super(blockSettings);
    }

    @Nonnull
    public ActionResult onUse2(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockHitResult hit) {
        return IBlock.checkHoldingBrush((World)world, (PlayerEntity)player, () -> {
            world.setBlockState(pos, state.cycle(new org.mtr.mapping.holder.Property((Property)PRStationNameEntrance.STYLE.data)));
            this.propagate(world, pos, IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING).rotateYClockwise(), new org.mtr.mapping.holder.Property((Property)PRStationNameEntrance.STYLE.data), 1);
            this.propagate(world, pos, IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING).rotateYCounterclockwise(), new org.mtr.mapping.holder.Property((Property)PRStationNameEntrance.STYLE.data), 1);
        });
    }

    public BlockState getPlacementState2(ItemPlacementContext ctx) {
        Direction side = ctx.getSide();
        if (side != Direction.UP && side != Direction.DOWN) {
            return this.getDefaultState2().with(new org.mtr.mapping.holder.Property((Property)PRStationNameEntrance.FACING.data), (Comparable)side.getOpposite().data);
        }
        return null;
    }

    @Nonnull
    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        boolean tall = IBlock.getStatePropertySafe((BlockState)state, (IntegerProperty)STYLE) % 2 == 1;
        return IBlock.getVoxelShapeByDirection((double)0.0, (double)(tall ? 0.0 : 4.0), (double)0.0, (double)16.0, (double)(tall ? 16.0 : 12.0), (double)1.0, (Direction)IBlock.getStatePropertySafe((BlockState)state, (DirectionProperty)FACING));
    }

    @Nonnull
    public VoxelShape getCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return VoxelShapes.empty();
    }

    @Nonnull
    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockEntity(blockPos, blockState);
    }

    public void addBlockProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)FACING);
        properties.add((HolderBase<?>)STYLE);
    }

    public static class BlockEntity
    extends BlockStationNameBase.BlockEntityBase {
        public BlockEntity(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.STATION_NAME_ENTRANCE.get(), pos, state, 0.0f, 0.00625f, false);
        }

        public int getColor(BlockState state) {
            switch (IBlock.getStatePropertySafe((BlockState)state, (IntegerProperty)BlockStationNameBase.COLOR)) {
                case 1: {
                    return -5592406;
                }
                case 2: {
                    return -16777216;
                }
            }
            return -1;
        }
    }
}

