/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.network;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ServerTeleport {
    String player;
    BlockPos pos;
    ResourceLocation world;
    String target;

    public ServerTeleport(String player, BlockPos pos, ResourceLocation world) {
        this.player = player;
        this.pos = pos;
        this.world = world;
        this.target = "";
    }

    public ServerTeleport(String player, String target) {
        this.player = player;
        this.pos = new BlockPos(0, 0, 0);
        this.world = new ResourceLocation("minecraft:overworld");
        this.target = target;
    }

    public ServerTeleport(FriendlyByteBuf buf) {
        this.player = buf.m_130277_();
        this.pos = buf.m_130135_();
        this.world = buf.m_130281_();
        this.target = buf.m_130277_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.player);
        buf.m_130064_(this.pos);
        buf.m_130085_(this.world);
        buf.m_130070_(this.target);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean succes = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer p = ((NetworkEvent.Context)ctx.get()).getSender().m_20194_().m_6846_().m_11255_(this.player);
            if (p == null) {
                return;
            }
            if (this.target.isEmpty() && this.pos != null && this.world != null) {
                ResourceKey key = Level.f_46428_;
                for (ResourceKey w : ((NetworkEvent.Context)ctx.get()).getSender().f_8924_.m_129784_()) {
                    if (!w.m_135782_().equals((Object)this.world)) continue;
                    key = w;
                    break;
                }
                p.m_8999_(((NetworkEvent.Context)ctx.get()).getSender().m_20194_().m_129880_(key), (double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), p.f_19859_, p.f_19860_);
                succes.set(true);
            } else if (this.target != null && !this.target.isEmpty()) {
                ServerPlayer t = ((NetworkEvent.Context)ctx.get()).getSender().m_20194_().m_6846_().m_11255_(this.target);
                BlockPos bp = t.m_20183_();
                p.m_8999_(t.m_9236_(), (double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_(), t.f_19859_, t.f_19860_);
                succes.set(true);
            }
        });
        ctx.get().setPacketHandled(true);
        return succes.get();
    }
}

