/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.network;

import com.podloot.eyemod.items.ItemDevice;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ServerSendChat {
    String sender;
    String msg;
    boolean local;
    int dis;

    public ServerSendChat(String sender, String msg, boolean local, int dis) {
        this.sender = sender;
        this.msg = msg;
        this.local = local;
        this.dis = dis;
    }

    public ServerSendChat(FriendlyByteBuf buf) {
        this.sender = buf.m_130277_();
        this.msg = buf.m_130277_();
        this.local = buf.readBoolean();
        this.dis = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.sender);
        buf.m_130070_(this.msg);
        buf.writeBoolean(this.local);
        buf.writeInt(this.dis);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean succes = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer p = ((NetworkEvent.Context)ctx.get()).getSender();
            for (Level w : ((NetworkEvent.Context)ctx.get()).getSender().f_8924_.m_129785_()) {
                for (Player player : w.m_6907_()) {
                    ArrayList stacks = new ArrayList();
                    stacks.addAll(player.m_150109_().f_35974_);
                    stacks.addAll(player.m_150109_().f_35976_);
                    for (ItemStack s : stacks) {
                        if (!(s.m_41720_() instanceof ItemDevice) || !s.m_41783_().m_128441_("apps") || !s.m_41783_().m_128437_("apps", 8).contains((Object)StringTag.m_129297_((String)"eyemod:chat"))) continue;
                        int phone_distance = s.m_41783_().m_128469_("settings").m_128451_("chat_dis");
                        boolean phone_local = s.m_41783_().m_128469_("settings").m_128471_("chat_local");
                        int player_distance = player.m_20183_().m_123333_((Vec3i)p.m_20183_());
                        if (this.dis == 0) {
                            this.dis = 128;
                        }
                        if (phone_distance == 0) {
                            phone_distance = 128;
                        }
                        if (phone_local && player_distance > phone_distance || this.local && player_distance > this.dis) continue;
                        ListTag chat = s.m_41783_().m_128437_("chat", 8);
                        if (chat.size() > 50) {
                            chat.remove(0);
                        }
                        chat.add((Object)StringTag.m_129297_((String)("<" + this.sender + "> " + this.msg)));
                        s.m_41783_().m_128365_("chat", (Tag)chat);
                        succes.set(true);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
        return succes.get();
    }
}

