/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.network;

import com.podloot.eyemod.blocks.entities.RouterEntity;
import com.podloot.eyemod.gui.util.Naming;
import com.podloot.eyemod.lib.gui.util.Pos;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ServerRouterData {
    Pos router;
    int action;
    String key;
    CompoundTag tag;

    public ServerRouterData(Pos router, Naming.Action action, String key, Tag tag) {
        this.router = router;
        this.action = action.action;
        this.key = key;
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("value", (Tag)(tag != null ? tag : StringTag.m_129297_((String)"")));
        this.tag = nbt;
    }

    public ServerRouterData(FriendlyByteBuf buf) {
        this.router = new Pos().fromString(buf.m_130277_());
        this.action = buf.readInt();
        this.key = buf.m_130277_();
        this.tag = buf.m_130260_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.router.toNbt());
        buf.writeInt(this.action);
        buf.m_130070_(this.key);
        buf.m_130079_(this.tag);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean succes = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerLevel lvl;
            BlockPos pos = this.router.getPos();
            ResourceLocation world = this.router.getWorld();
            ResourceKey wkey = Level.f_46428_;
            for (ResourceKey w : ((NetworkEvent.Context)ctx.get()).getSender().f_8924_.m_129784_()) {
                if (!w.m_135782_().equals((Object)world)) continue;
                wkey = w;
                break;
            }
            if ((lvl = ((NetworkEvent.Context)ctx.get()).getSender().m_20194_().m_129880_(wkey)).m_7702_(pos) instanceof RouterEntity) {
                ((RouterEntity)lvl.m_7702_(pos)).setData(this.action, this.key, this.tag.m_128423_("value"));
            }
            succes.set(true);
        });
        ctx.get().setPacketHandled(true);
        return succes.get();
    }
}

