/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.network;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ServerExplode {
    BlockPos pos;
    ResourceLocation world;
    int size;
    boolean fire;
    boolean dmg;

    public ServerExplode(BlockPos pos, ResourceLocation world, int size, boolean fire, boolean dmg) {
        this.pos = pos;
        this.world = world;
        this.size = size;
        this.fire = fire;
        this.dmg = dmg;
    }

    public ServerExplode(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.world = buf.m_130281_();
        this.size = buf.readInt();
        this.fire = buf.readBoolean();
        this.dmg = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130085_(this.world);
        buf.writeInt(this.size);
        buf.writeBoolean(this.fire);
        buf.writeBoolean(this.dmg);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean succes = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ResourceKey key = Level.f_46428_;
            for (ResourceKey w : ((NetworkEvent.Context)ctx.get()).getSender().f_8924_.m_129784_()) {
                if (!w.m_135782_().equals((Object)this.world)) continue;
                key = w;
                break;
            }
            ((NetworkEvent.Context)ctx.get()).getSender().m_20194_().m_129880_(key).m_7703_((Entity)((NetworkEvent.Context)ctx.get()).getSender(), DamageSource.m_19373_((LivingEntity)((NetworkEvent.Context)ctx.get()).getSender()), null, (double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), (float)this.size, this.fire, this.dmg ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE);
            succes.set(true);
        });
        ctx.get().setPacketHandled(true);
        return succes.get();
    }
}

