/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.network;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.network.NetworkEvent;

public class ServerEffect {
    String player;
    int effect;
    int lvl;
    int time;

    public ServerEffect(String player, int effect, int lvl, int time) {
        this.player = player;
        this.effect = effect;
        this.lvl = lvl;
        this.time = time;
    }

    public ServerEffect(FriendlyByteBuf buf) {
        this.player = buf.m_130277_();
        this.effect = buf.readInt();
        this.lvl = buf.readInt();
        this.time = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.player);
        buf.writeInt(this.effect);
        buf.writeInt(this.lvl);
        buf.writeInt(this.time);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean succes = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer p = ((NetworkEvent.Context)ctx.get()).getSender().m_20194_().m_6846_().m_11255_(this.player);
            if (p == null) {
                return;
            }
            if (this.lvl == 0 || this.time == 0) {
                p.m_21219_();
            } else {
                MobEffectInstance se = new MobEffectInstance(MobEffect.m_19453_((int)this.effect), this.time, this.lvl, false, false);
                p.m_7292_(se);
            }
            succes.set(true);
        });
        ctx.get().setPacketHandled(true);
        return succes.get();
    }
}

