/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.network;

import com.podloot.eyemod.config.EyeConfigData;
import com.podloot.eyemod.lib.gui.util.Pos;
import com.podloot.eyemod.network.ClientAccess;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ClientGuiOpen {
    String id;
    int hand;
    int gui;
    CompoundTag config;
    boolean opApps;
    boolean operator;
    String pos;

    public ClientGuiOpen(String id, InteractionHand hand, EyeConfigData config, boolean opApps, boolean operator) {
        this.id = id;
        this.hand = hand == InteractionHand.MAIN_HAND ? 0 : 1;
        this.gui = 0;
        this.config = config.data;
        this.opApps = opApps;
        this.operator = operator;
        this.pos = "";
    }

    public ClientGuiOpen(String id, InteractionHand hand, Pos pos, boolean canOpen) {
        this.id = id;
        this.hand = hand == InteractionHand.MAIN_HAND ? 0 : 1;
        this.gui = 1;
        this.config = new CompoundTag();
        this.opApps = canOpen;
        this.operator = false;
        this.pos = pos.toNbt();
    }

    public ClientGuiOpen(FriendlyByteBuf buf) {
        this.id = buf.m_130277_();
        this.hand = buf.readInt();
        this.gui = buf.readInt();
        this.config = buf.m_130260_();
        this.opApps = buf.readBoolean();
        this.operator = buf.readBoolean();
        this.pos = buf.m_130277_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.id);
        buf.writeInt(this.hand);
        buf.writeInt(this.gui);
        buf.m_130079_(this.config);
        buf.writeBoolean(this.opApps);
        buf.writeBoolean(this.operator);
        buf.m_130070_(this.pos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean succes = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> succes.set(ClientAccess.openDevice(this.id, this.hand, this.gui, this.config, this.opApps, this.operator, new Pos().fromString(this.pos)))));
        ctx.get().setPacketHandled(true);
        return succes.get();
    }
}

