/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.lib.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.util.Space;
import com.podloot.eyemod.lib.gui.widgets.EyeText;
import net.minecraft.client.Minecraft;

public abstract class EyeWidget {
    boolean clickable = false;
    boolean hide = false;
    private EyeText hover = null;
    EyeWidget parent;
    int primary = -3223858;
    int secondary = -12303292;
    Line text;
    int textcolor = -1;
    boolean enabled = true;
    boolean focussed = false;
    boolean background = false;
    int width = 12;
    int height = 12;
    int x;
    int y;
    int offx;
    int offy;

    public EyeWidget(boolean clickable, int width, int height) {
        this.setSize(width, height);
        this.clickable = clickable;
    }

    public void copy(EyeWidget e) {
        this.hide = e.hide;
        this.parent = e.parent;
        this.primary = e.primary;
        this.secondary = e.secondary;
        this.text = e.text;
        this.textcolor = e.textcolor;
        this.enabled = e.enabled;
        this.focussed = e.focussed;
        this.background = e.background;
        this.width = e.width;
        this.height = e.height;
        this.x = e.x;
        this.y = e.y;
        this.offx = e.offx;
        this.offy = e.offx;
    }

    public void setColor(int color) {
        this.primary = color;
    }

    public void setBack(int color) {
        this.background = true;
        if (this.background) {
            this.setColor(color);
        }
    }

    public void setColor(int primary, int secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    public void setSize(int w, int h) {
        this.setWidth(w);
        this.setHeight(h);
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setOff(int x, int y) {
        this.offx = x;
        this.offy = y;
    }

    public void draw(PoseStack matrices, int x, int y) {
        if (this.background) {
            EyeDraw.nine(matrices, EyeLib.PLANE, x, y, this.width, this.height, this.primary);
        }
    }

    public void drawHover(PoseStack matrices, int mouseX, int mouseY) {
        if (this.hover != null) {
            this.hover.draw(matrices, mouseX - 24, mouseY + 4);
        }
    }

    public void drawText(PoseStack matrices, int x, int y, int w, int h) {
        int cx = this.text.getCenteredX();
        int cy = this.text.getCenteredY();
        EyeDraw.text(matrices, this.text, x - w / 2 * (cx - 1), y - h / 2 * (cy - 1));
    }

    public void tick(int mx, int my) {
    }

    public void close() {
    }

    public EyeWidget getHit(int x, int y) {
        if (this.inBounds(x, y)) {
            return this;
        }
        return null;
    }

    public boolean inBounds(int x, int y) {
        return x >= this.getGlobalX() && y >= this.getGlobalY() && x <= this.getGlobalX() + this.getWidth() && y < this.getGlobalY() + this.getHeight();
    }

    public int getGlobalX() {
        if (this.getParent() == null) {
            return this.getX();
        }
        return this.getX() + this.getParent().getGlobalX();
    }

    public int getGlobalY() {
        if (this.getParent() == null) {
            return this.getY();
        }
        return this.getY() + this.getParent().getGlobalY();
    }

    public int getX() {
        return this.x + this.offx;
    }

    public int getY() {
        return this.y + this.offy;
    }

    public int getOffX() {
        return this.offx;
    }

    public int getOffY() {
        return this.offy;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean charTyped(char chr, int modifiers) {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    public void mouseMoved(double mouseX, double mouseY) {
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isFocussed() {
        return this.focussed;
    }

    public void setFocussed(boolean focussed) {
        this.focussed = focussed;
    }

    public EyeWidget getFocussed() {
        return this.focussed ? this : null;
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void clearFocus() {
        this.focussed = false;
    }

    public void hide(boolean hide) {
        this.hide = hide;
    }

    public boolean isHidden() {
        return this.hide;
    }

    public int getPrimary() {
        return this.primary;
    }

    public int getSecondary() {
        return this.secondary;
    }

    public EyeWidget getParent() {
        return this.parent;
    }

    public void setParent(EyeWidget parent) {
        this.parent = parent;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setAsSpace(Space space) {
        this.height = space.height;
        this.width = space.width;
        this.x = space.x;
        this.y = space.y;
    }

    public void setText(Line text) {
        this.text = text;
        if (text != null) {
            this.textcolor = text.getColor();
        }
    }

    public Line getText() {
        return this.text;
    }

    public EyeText getHover() {
        return this.hover;
    }

    public void setHover(Line hover) {
        hover.setAllingment(0, 0);
        int ts = Minecraft.m_91087_().f_91062_.m_92895_(hover.getText()) + 8;
        this.hover = new EyeText(ts >= 140 ? 140 : ts, hover);
        this.hover.setBack(-14540254);
    }

    public static enum Axis {
        HORIZONTAL,
        VERTICAL;

    }
}

