/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.lib.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.gui.util.Music;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.util.Space;
import com.podloot.eyemod.lib.gui.widgets.EyeInteract;
import net.minecraft.sounds.SoundEvents;

public class EyeToggle
extends EyeInteract {
    boolean state;
    int size = 12;
    Space space;

    public EyeToggle(int width, int height) {
        super(width, height);
        this.space = new Space(width / 2 - 10, height / 2 - 6, 20, 12);
        this.size = this.space.height < this.space.width ? this.space.height : -1;
        this.setColor(-3223858, -9650069);
    }

    public void setState(boolean state) {
        this.state = state;
    }

    @Override
    public void setText(Line text) {
        this.text = text.setAllingment(1, 0);
        this.space = new Space(0, this.height / 2 - 6, 20, 12);
    }

    public void setToggleSpace(Space space) {
        this.space = space;
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        super.draw(matrices, x, y);
        EyeDraw.nine(matrices, EyeLib.SLIDER, x + this.space.x, y + this.space.y, this.space.width, this.space.height, this.state ? this.secondary : this.primary);
        EyeDraw.nine(matrices, EyeLib.SLIDER_BORDER, x + this.space.x, y + this.space.y, this.space.width, this.space.height, this.isHovered() ? -1 : -16777216);
        if (this.size > 0) {
            EyeDraw.nine(matrices, EyeLib.SLIDER, x + this.space.x + (this.state ? this.space.width - this.size : 0), y + this.space.y, this.size, this.space.height, this.primary);
        }
        if (this.text != null) {
            this.drawText(matrices, x + this.space.width + 2, y, this.width - this.space.width - 2, this.height);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isEnabled()) {
            Music.sound(SoundEvents.f_12490_);
            boolean bl = this.state = !this.state;
            if (this.action != null) {
                this.action.run();
            }
        }
        return true;
    }

    public boolean getToggle() {
        return this.state;
    }
}

