/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.lib.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeInteract;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;

public abstract class EyeTextInput
extends EyeInteract {
    int cursor = 0;
    int ticks = 0;
    int max_length = 256;
    String limit = "";
    String disallowed = "";
    Font client;
    String input = "";
    boolean suggest = false;
    String[] suggestions = new String[0];
    int option = 0;

    public EyeTextInput(int width, int height) {
        super(width, height);
        this.client = Minecraft.m_91087_().f_91062_;
        this.setColor(-14540254, -2236963);
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        int cb = this.isFocussed() || this.isHovered() ? this.secondary : -16777216;
        EyeDraw.nine(matrices, EyeLib.PLANE, x, y, this.width, this.height, this.primary);
        EyeDraw.nine(matrices, EyeLib.PLANE_BORDER, x, y, this.width, this.height, cb);
        if (this.text != null && this.input.isEmpty()) {
            this.drawText(matrices, x + 4, y + 4, this.getWidth() - 8, this.getHeight() - 8);
        }
        if (!this.input.isEmpty()) {
            String s;
            this.setCursor(this.cursor);
            if (this.suggest && (s = this.getSuggestion(this.option)) != null) {
                this.drawSuggest(matrices, x, y, s);
            }
            this.drawLines(matrices, x, y);
        }
        if (this.ticks / 30 % 2 == 0 && this.isFocussed()) {
            this.drawCursor(matrices, x, y);
        }
        ++this.ticks;
        if (this.ticks > 1001) {
            this.ticks = 0;
        }
    }

    public abstract void drawCursor(PoseStack var1, int var2, int var3);

    public abstract void drawLines(PoseStack var1, int var2, int var3);

    public abstract void drawSuggest(PoseStack var1, int var2, int var3, String var4);

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.suggest) {
            if (keyCode == 257) {
                String s = this.getSuggestion(this.option);
                if (s != null) {
                    this.input = s;
                    this.setCursor(this.input.length());
                }
            } else if (keyCode == 258) {
                ++this.option;
            }
        }
        switch (keyCode) {
            case 259: {
                this.removeText(1);
                break;
            }
            case 263: {
                this.setCursor(this.cursor - 1);
                return true;
            }
            case 262: {
                this.setCursor(this.cursor + 1);
                return true;
            }
        }
        return this.keyPressed(keyCode);
    }

    public abstract boolean keyPressed(int var1);

    public void setCursor(int p) {
        this.cursor = p < 0 ? 0 : (p > this.input.length() ? this.input.length() : p);
    }

    public void setDisallowed(String dis) {
        this.disallowed = dis;
    }

    public void setAllowed(String lim) {
        this.limit = lim;
    }

    public void setLimit(int lim) {
        this.max_length = lim;
    }

    @Override
    public boolean charTyped(char chr, int modifiers) {
        if (("" + chr).contains("|")) {
            return false;
        }
        this.insertText("" + chr);
        return true;
    }

    public void insertText(String s) {
        if (!this.valid(s)) {
            return;
        }
        this.setCursor(this.cursor);
        String before = this.input.substring(0, this.cursor);
        String after = this.input.substring(this.cursor, this.input.length());
        this.input = before + s + after;
        this.cursor = before.length() + s.length();
    }

    public boolean valid(String s) {
        if (this.input.length() + s.length() > this.max_length) {
            return false;
        }
        if (!this.disallowed.isEmpty() && s.matches(this.disallowed) && !s.equals("|")) {
            return false;
        }
        return this.limit.isEmpty() || s.matches(this.limit) || s.equals("|");
    }

    public void removeText(int a) {
        String before = this.input.substring(0, this.cursor);
        String after = this.input.substring(this.cursor, this.input.length());
        if (before.endsWith(" | ")) {
            a = 3;
        }
        if (before.length() > a) {
            this.input = before.substring(0, before.length() - a) + after;
            this.cursor = before.length() - a;
        } else {
            this.input = after;
            this.cursor = 0;
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.setCursor(this.input.length());
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    @Override
    public void setAction(Runnable action) {
        this.action = action;
    }

    public void setSuggest(String[] lib) {
        this.suggestions = lib;
        this.suggest = true;
        this.setHover(new Line("text.eyemod.hover_suggestion"));
    }

    public String getSuggestion(int i) {
        String in = this.input.toLowerCase();
        in = in.replace("_", " ");
        int c = 0;
        for (String s : this.suggestions) {
            String subs;
            if (s == null || s.length() <= in.length() || !(subs = s.toLowerCase()).startsWith(in) && !subs.replace("_", " ").startsWith(in)) continue;
            if (c == i) {
                return s;
            }
            ++c;
        }
        this.option = 0;
        return null;
    }
}

