/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.lib.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeTextInput;
import java.util.ArrayList;
import java.util.List;

public class EyeTextArea
extends EyeTextInput {
    List<String> lines = new ArrayList<String>();
    List<String> subLines = new ArrayList<String>();
    int cursorLine = 0;
    int startLine = 0;
    int totalLines = 1;
    int maxLines = 24;

    public EyeTextArea(int width, int height) {
        super(width, height);
        this.totalLines = (int)((float)(height - 8) / 9.0f);
    }

    @Override
    public void setText(Line text) {
        this.text = text.setAllingment(1, 1).setColor(-8947849);
    }

    @Override
    public void drawCursor(PoseStack matrices, int x, int y) {
        int cl = this.cursorLine - this.startLine;
        if (cl >= 0 && cl < this.lines.size()) {
            String line = this.lines.get(this.cursorLine);
            int i = this.cursor - this.getSubLength();
            i = i < 0 ? 0 : (i > line.length() ? line.length() : i);
            int w = this.client.m_92895_(line.substring(0, i));
            EyeDraw.text(matrices, "|", x + 4 + w, y + 4 + cl * 9, -1);
        } else {
            EyeDraw.text(matrices, "|", x + 4, y + 4, -1);
        }
    }

    @Override
    public void drawLines(PoseStack matrices, int x, int y) {
        this.lines = EyeLib.getLines(this.input, this.getWidth() - 8);
        this.cursorLine = this.getCursorLine();
        for (int i = 0; i < this.totalLines; ++i) {
            int si = i;
            if (this.cursorLine >= this.totalLines) {
                si = i + (this.cursorLine - this.totalLines) + 1;
            }
            if (i == 0) {
                this.startLine = si;
            }
            if (si >= this.lines.size() || si < 0) continue;
            EyeDraw.text(matrices, this.lines.get(si), x + 4, y + 4 + i * 9, -1);
        }
    }

    @Override
    public void drawSuggest(PoseStack matrices, int x, int y, String s) {
    }

    public int getCursorLine() {
        if (this.cursor > this.input.length()) {
            return this.lines.size() - 1;
        }
        if (this.cursor <= 0) {
            return 0;
        }
        String subInput = this.input.substring(0, this.cursor);
        this.subLines = EyeLib.getLines(subInput, this.getWidth() - 8);
        return this.subLines.size() - 1;
    }

    public int getSubLength() {
        int i;
        if (this.cursor <= 0) {
            return 0;
        }
        if (this.cursor > this.input.length()) {
            return this.input.length();
        }
        String subInput = this.input.substring(0, this.cursor);
        int t = 0;
        for (i = 0; i < subInput.length(); ++i) {
            if (subInput.charAt(i) != '|') continue;
            ++t;
        }
        for (i = 0; i < this.subLines.size() - 1; ++i) {
            t += this.subLines.get(i).length();
        }
        return t;
    }

    @Override
    public boolean keyPressed(int keyCode) {
        switch (keyCode) {
            case 257: {
                this.insertText("|");
                break;
            }
            case 264: {
                this.moveCursor(1);
                break;
            }
            case 265: {
                this.moveCursor(-1);
            }
        }
        return false;
    }

    @Override
    public boolean valid(String s) {
        if (EyeLib.getLines(this.input + s, this.getWidth() - 8).size() > this.maxLines) {
            return false;
        }
        return super.valid(s);
    }

    public void moveCursor(int move) {
        int currentLine;
        int subLength = this.getSubLength();
        int curLength = this.cursor - subLength;
        int n = currentLine = this.cursorLine >= 0 && this.cursorLine < this.lines.size() ? this.lines.get(this.cursorLine).length() : 0;
        if (move < 0) {
            this.setCursor(this.cursor - curLength - 1);
        } else if (move > 0) {
            int nextLine = this.cursorLine + 1 >= 0 && this.cursorLine + 1 < this.lines.size() ? this.lines.get(this.cursorLine + 1).length() : 0;
            this.setCursor(this.cursor + nextLine + (currentLine - curLength) + 1);
        }
    }

    public void setLineLimit(int limit) {
        this.maxLines = limit >= 24 ? 24 : (limit < 0 ? 0 : limit);
    }
}

