/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.lib.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import java.util.List;

public class EyeText
extends EyeWidget {
    List<String> lines;
    int textHeight = 11;

    public EyeText(int width, int height, Line text) {
        super(false, width, height);
        this.setText(text);
    }

    public EyeText(int width, Line text) {
        this(width, 0, text);
    }

    @Override
    public void setText(Line text) {
        this.text = text;
        this.lines = EyeLib.getLines(text.getText(), (int)((float)(this.width - 8) / text.getScale()));
        this.textHeight = (int)((float)this.textHeight * text.getScale());
        int h = this.lines.size() * this.textHeight;
        this.setHeight(this.height < h + 6 ? h + 6 : this.height);
    }

    public void setAlignment(int x, int y) {
        this.text = this.text.setAllingment(x, y);
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        super.draw(matrices, x, y);
        int w = (this.width - 8) / 2;
        int h = (this.height - 6) / 2;
        int cx = this.text.getCenteredX();
        int cy = this.text.getCenteredY();
        int yoff = this.lines.size() * this.textHeight / 2 - this.textHeight / 2;
        for (int i = 0; i < this.lines.size(); ++i) {
            Line line = new Line(this.lines.get(i), this.text);
            EyeDraw.text(matrices, line, x + 4 - w * (cx - 1), y + 3 - (h - yoff) * (cy - 1) + i * this.textHeight);
        }
    }

    public float getTextHeight() {
        return this.textHeight;
    }
}

