/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.lib.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeClickable;
import java.util.ArrayList;
import java.util.List;

public class EyeSwitch
extends EyeClickable {
    List<Line> options = new ArrayList<Line>();
    int state = 0;

    public EyeSwitch(int width, int height) {
        super(width, height);
    }

    public void addState(Line line) {
        this.options.add(line);
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        EyeDraw.nine(matrices, EyeLib.PLANE, x, y, this.width, this.height, this.secondary);
        int w = this.width / this.options.size();
        EyeDraw.nine(matrices, EyeLib.PLANE, x + w * this.state, y, w, this.height, this.primary);
        EyeDraw.nine(matrices, EyeLib.PLANE_BORDER, x + w * this.state, y, w, this.height, this.isHovered() ? -1 : -16777216);
        if (!this.options.isEmpty()) {
            for (int i = 0; i < this.options.size(); ++i) {
                this.options.get(i).setColor(this.isEnabled() ? this.textcolor : -12303292);
                EyeDraw.text(matrices, this.options.get(i), x + w * i + w / 2, y + this.height / 2);
            }
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.state = this.state < this.options.size() - 1 ? ++this.state : 0;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public int getState() {
        return this.state;
    }
}

