/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.lib.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.util.Space;
import com.podloot.eyemod.lib.gui.widgets.EyeInteract;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;
import java.util.function.Supplier;

public class EyeSlider
extends EyeInteract {
    int min;
    int max;
    int slide = 0;
    int size = 12;
    int old_value = 0;
    boolean dragging = false;
    EyeWidget.Axis axis = EyeWidget.Axis.HORIZONTAL;
    Supplier showValue;
    String form;
    Space space;

    public EyeSlider(int width, int height, int min, int max) {
        super(width, height);
        this.min = min;
        this.max = max < min ? min : max;
        this.size = 12;
        this.space = new Space(0, height / 2 - 6, width, 12);
        this.showValue = () -> this.getValue();
    }

    public void setAxis(EyeWidget.Axis axis) {
        this.axis = axis;
        this.space = axis == EyeWidget.Axis.VERTICAL ? new Space(this.width / 2 - 6, 0, 12, this.height) : new Space(0, this.height / 2 - 6, this.width, 12);
    }

    public void setSliderSpace(Space space) {
        this.space = space;
    }

    public void setSize(int dotsize) {
        this.size = dotsize;
    }

    @Override
    public void setText(Line text) {
        this.text = text;
        this.form = text.getText().replace("{v}", "%s");
        if (this.axis == EyeWidget.Axis.HORIZONTAL) {
            this.space = new Space(0, this.height - 12, this.width, 12);
        }
    }

    public void setState(int state) {
        this.setValue(state);
    }

    public void setShowValue(Supplier show) {
        this.showValue = show;
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        super.draw(matrices, x, y);
        boolean a = this.axis == EyeWidget.Axis.HORIZONTAL;
        EyeDraw.nine(matrices, EyeLib.PLANE, x + this.space.x + 2, y + this.space.y + 2, this.space.width - 4, this.space.height - 4, this.secondary);
        if (this.text != null) {
            this.text.setText(String.format(this.form, this.showValue.get()));
            this.drawText(matrices, x + 4, y + 4, this.width - 8, 8);
        }
        EyeDraw.nine(matrices, EyeLib.SLIDER, x + this.space.x + (a ? this.getLoc(a) : 0), y + this.space.y + (a ? 0 : this.getLoc(a)), a ? this.size : this.space.width, a ? this.space.height : this.size, this.primary);
        EyeDraw.nine(matrices, EyeLib.SLIDER_BORDER, x + this.space.x + (a ? this.getLoc(a) : 0), y + this.space.y + (a ? 0 : this.getLoc(a)), a ? this.size : this.space.width, a ? this.space.height : this.size, this.isHovered() ? -1 : -16777216);
    }

    public int getLoc(boolean a) {
        this.slide = this.slide < 0 ? 0 : (this.slide > (a ? this.space.width : this.space.height) - this.size ? (a ? this.space.width : this.space.height) - this.size : this.slide);
        return this.slide;
    }

    public int getValue() {
        float range;
        float total;
        float steps;
        boolean a = this.axis == EyeWidget.Axis.HORIZONTAL;
        float l = this.getLoc(a);
        int f = (int)(l / (steps = (total = a ? (float)(this.space.width - this.size) : (float)(this.space.height - this.size)) / (range = (float)(this.max - this.min + 1)))) + this.min;
        return f < this.min ? this.min : (f > this.max ? this.max : f);
    }

    public void setValue(int amount) {
        float total;
        boolean a = this.axis == EyeWidget.Axis.HORIZONTAL;
        float f = total = a ? (float)(this.space.width - this.size) : (float)(this.space.height - this.size);
        if (--amount >= this.max) {
            this.slide = (int)total;
            return;
        }
        if (amount <= this.min) {
            this.slide = 0;
            return;
        }
        float range = this.max - this.min + 1;
        float steps = total / range;
        this.slide = (int)(steps * (float)amount + steps / 2.0f + (float)this.min);
    }

    @Override
    public void tick(int mx, int my) {
        if (this.dragging) {
            this.slide = this.axis == EyeWidget.Axis.HORIZONTAL ? mx - 6 - this.getGlobalX() : my - 6 - this.getGlobalY();
        }
        super.tick(mx, my);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.dragging = true;
        this.old_value = this.getValue();
        return true;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.dragging = false;
        if (this.getValue() != this.old_value) {
            this.old_value = this.getValue();
            if (this.action != null) {
                this.action.run();
            }
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        this.slide = (int)((double)this.slide + amount);
        return true;
    }

    @Override
    public boolean isHovered() {
        return super.isHovered() || this.dragging;
    }
}

