/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.lib.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.panels.EyeScrollPanel;
import com.podloot.eyemod.lib.gui.widgets.EyeInteract;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;

public class EyeScrollBar
extends EyeInteract {
    public EyeWidget.Axis axis;
    EyeScrollPanel scroll;
    int min;
    int max;
    int xoff;
    int yoff;
    int slide = 0;
    int size = 12;
    boolean dragging = false;

    public EyeScrollBar(int width, int height, EyeWidget.Axis axis) {
        super(width, height);
        this.axis = axis;
        this.min = 0;
        this.max = 100;
    }

    public void setState(int state) {
        this.setValue(state);
    }

    public void setBar(EyeScrollPanel scroll) {
        this.max = scroll.axis == EyeWidget.Axis.HORIZONTAL ? scroll.getScrollWidth() - scroll.getWidth() : scroll.getScrollHeight() - scroll.getHeight();
        int n = this.max = this.max < 0 ? 0 : this.max;
        if (this.axis == EyeWidget.Axis.HORIZONTAL) {
            int s = this.getHeight() - this.max;
            this.size = this.max < this.getWidth() ? this.getWidth() : (s > 10 ? s : 10);
        } else {
            int s;
            int n2 = this.max <= 0 ? this.getHeight() : (s = this.max <= this.getHeight() * 4 ? this.getHeight() - this.max / 4 : 10);
            this.size = s < 10 ? 10 : (s > this.getHeight() ? this.getHeight() : s);
        }
        this.scroll = scroll;
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        boolean a = this.axis == EyeWidget.Axis.HORIZONTAL;
        EyeDraw.nine(matrices, EyeLib.PLANE, x, y, this.width, this.height, this.secondary);
        EyeDraw.nine(matrices, EyeLib.PLANE, x + (a ? this.getLoc(a) : 0), y + (a ? 0 : this.getLoc(a)), a ? this.size : this.width, a ? this.height : this.size, this.primary);
        EyeDraw.nine(matrices, EyeLib.PLANE_BORDER, x + (a ? this.getLoc(a) : 0), y + (a ? 0 : this.getLoc(a)), a ? this.size : this.width, a ? this.height : this.size, this.isHovered() ? -1 : -16777216);
    }

    public int getLoc(boolean a) {
        this.slide = this.slide < 0 ? 0 : (this.slide > (a ? this.width : this.height) - this.size ? (a ? this.width : this.height) - this.size : this.slide);
        return this.slide;
    }

    public int getValue() {
        float range;
        float total;
        float steps;
        boolean a = this.axis == EyeWidget.Axis.HORIZONTAL;
        float l = this.getLoc(a);
        int f = (int)(l / (steps = (total = a ? (float)(this.width - this.size) : (float)(this.height - this.size)) / (range = (float)(this.max - this.min + 1)))) + this.min;
        return f < this.min ? this.min : (f > this.max ? this.max : f);
    }

    public void setValue(int amount) {
        float total;
        boolean a = this.axis == EyeWidget.Axis.HORIZONTAL;
        float f = total = a ? (float)(this.width - this.size) : (float)(this.height - this.size);
        if (amount >= this.max || amount == -1) {
            this.slide = (int)total;
            return;
        }
        if (amount <= this.min) {
            this.slide = 0;
            return;
        }
        float range = this.max - this.min + 1;
        float steps = total / range;
        this.slide = (int)(steps * (float)amount + steps / 2.0f + (float)this.min);
    }

    @Override
    public void tick(int mx, int my) {
        if (this.dragging) {
            if (this.axis == EyeWidget.Axis.HORIZONTAL) {
                this.slide = mx + this.xoff - this.size / 2 - this.getGlobalX();
                this.scroll.setScroll(this.axis, this.getValue());
            } else {
                this.slide = my + this.yoff - this.size / 2 - this.getGlobalY();
                this.scroll.setScroll(this.axis, this.getValue());
            }
        }
        super.tick(mx, my);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.dragging = true;
        if (this.axis == EyeWidget.Axis.HORIZONTAL) {
            int mx = (int)mouseX - this.size / 2 - this.getGlobalX();
            this.xoff = mx > this.slide - this.size / 2 && mx < this.slide + this.size / 2 ? (mx - this.slide) * -1 : 0;
        } else {
            int my = (int)mouseY - this.size / 2 - this.getGlobalY();
            this.yoff = my > this.slide - this.size / 2 && my < this.slide + this.size / 2 ? (my - this.slide) * -1 : 0;
        }
        return true;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.dragging = false;
        return false;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        this.scroll((int)amount);
        return true;
    }

    public void scroll(int a) {
        this.slide += a;
        this.scroll.setScroll(this.axis, this.getValue());
    }

    @Override
    public boolean isHovered() {
        return super.isHovered() || this.dragging;
    }
}

