/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.lib.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;

public class EyeProcess
extends EyeWidget {
    int range;
    int state;
    String form;
    boolean isProcent;

    public EyeProcess(int width, int height, int range) {
        super(false, width, height);
        this.state = this.range = 100;
        this.isProcent = false;
        this.range = range;
        this.setState(range);
    }

    public void setText(Line text, boolean procent) {
        this.text = text;
        this.isProcent = procent;
        this.form = text.getText().replace("{v}", "%s");
    }

    @Override
    public void setText(Line text) {
        this.setText(text, false);
    }

    public void setState(int state) {
        this.setValue(state);
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        EyeDraw.nine(matrices, EyeLib.PLANE, x, y, this.width, this.height, this.primary);
        int p = (int)((float)this.width * (float)this.state / (float)this.range);
        if (p >= 0) {
            EyeDraw.nine(matrices, EyeLib.PLANE, x, y, p < 4 ? 4 : p, this.height, this.secondary);
        }
        if (this.text != null) {
            EyeDraw.text(matrices, this.text, x + this.width / 2, y + this.height / 2);
        }
    }

    @Override
    public void tick(int mx, int my) {
        if (this.text != null && this.form.contains("%s")) {
            if (this.isProcent) {
                int pr = Math.round((float)this.state / (float)this.range * 100.0f);
                this.text.setText(String.format(this.form, pr + "%"));
            } else {
                this.text.setText(String.format(this.form, this.state, this.range));
            }
        }
        super.tick(mx, my);
    }

    public int getValue() {
        return this.state;
    }

    public void setValue(int value) {
        this.state = value < 0 ? 0 : (this.state > this.range ? this.range : value);
    }
}

