/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.lib.gui.widgets;

import com.podloot.eyemod.lib.gui.panels.EyeBoxPanel;
import com.podloot.eyemod.lib.gui.panels.EyeListPanel;
import com.podloot.eyemod.lib.gui.panels.EyeScrollPanel;
import com.podloot.eyemod.lib.gui.widgets.EyeScrollBar;
import com.podloot.eyemod.lib.gui.widgets.EyeWidget;

public class EyeList
extends EyeScrollPanel {
    EyeWidget.Axis axis;
    EyeBoxPanel list;
    EyeScrollBar bar;
    EyeListPanel selected;
    Runnable action;

    public EyeList(int width, int height, EyeWidget.Axis axis) {
        super(width, height);
        this.axis = axis;
        boolean a = axis == EyeWidget.Axis.HORIZONTAL;
        this.list = new EyeBoxPanel(width - (a ? 0 : 10), height - (a ? 10 : 0), axis);
        this.list.setSpace(2);
        this.bar = new EyeScrollBar(a ? width : 8, a ? 8 : height, axis);
        this.bar.setColor(this.getPrimary(), this.getSecondary());
        this.add(this.list, 0, 0);
        this.add(this.bar, a ? 0 : width - 8, a ? height - 8 : 0);
        this.setScrollBar(axis, this.bar);
    }

    public void hideScrollbar(boolean h) {
        this.bar.hide(h);
    }

    public void clearSelection() {
        this.selected = null;
        for (EyeWidget w : this.list.getWidgets()) {
            if (!(w instanceof EyeListPanel)) continue;
            ((EyeListPanel)w).setSelected(false);
        }
    }

    public void updateItems() {
        this.list.setItems();
        this.setScrollBar(this.getAxis(), this.bar);
        this.setScroll(EyeWidget.Axis.HORIZONTAL, this.scroll_x);
        this.setScroll(EyeWidget.Axis.VERTICAL, this.scroll_y);
    }

    public void add(EyeWidget e) {
        this.add(-1, e);
    }

    public void add(int i, EyeWidget e) {
        if (e == null) {
            return;
        }
        this.list.add(i, e);
        this.setScrollBar(this.getAxis(), this.bar);
    }

    public boolean delete(int i) {
        return this.list.delete(i);
    }

    public boolean delete(EyeWidget e) {
        return this.list.delete(e);
    }

    public void clearList() {
        this.list.clear();
    }

    @Override
    public EyeWidget get(int i) {
        return this.list.get(i);
    }

    @Override
    public boolean has(EyeWidget e) {
        return this.list.has(e);
    }

    public void setSpace(int s) {
        this.list.setSpace(s);
    }

    public int sizeList() {
        return this.list.size();
    }

    public void setScroll(int value) {
        this.setScroll(this.getAxis(), value);
    }

    public int getScroll() {
        return this.getAxis() == EyeWidget.Axis.HORIZONTAL ? this.getScroll_x() : this.getScroll_y();
    }

    public EyeWidget.Axis getAxis() {
        return this.axis;
    }

    public EyeListPanel getSelected() {
        return this.selected;
    }

    public void onSelect(Runnable action) {
        this.action = action;
    }

    public void setSelected(EyeListPanel sel) {
        this.selected = sel;
        if (this.action != null && sel != null) {
            this.action.run();
        }
    }
}

