/*
 * Decompiled with CFR 0.152.
 */
package com.podloot.eyemod.lib.gui.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.podloot.eyemod.lib.gui.EyeDraw;
import com.podloot.eyemod.lib.gui.EyeLib;
import com.podloot.eyemod.lib.gui.util.Image;
import com.podloot.eyemod.lib.gui.util.Line;
import com.podloot.eyemod.lib.gui.widgets.EyeClickable;

public class EyeButton
extends EyeClickable {
    private Image icon;
    private int offset = 0;

    public EyeButton(int width, int height) {
        super(width, height);
    }

    public EyeButton(int width, int height, Line text) {
        super(width, height);
        this.setText(text);
    }

    public EyeButton(int width, int height, Image icon) {
        super(width, height);
        this.secondary = -1;
        this.setIcon(icon);
    }

    public void setOffset(int o) {
        this.offset = o;
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    @Override
    public void draw(PoseStack matrices, int x, int y) {
        EyeDraw.nine(matrices, EyeLib.PLANE, x, y, this.width, this.height, this.primary);
        EyeDraw.nine(matrices, EyeLib.PLANE_BORDER, x, y, this.width, this.height, this.isHovered() ? -1 : -16777216);
        if (this.text != null) {
            this.text.setColor(this.isEnabled() ? this.textcolor : -12303292);
            this.drawText(matrices, x + 4, y + 4, this.width - 8, this.height - 8);
        }
        if (this.icon != null) {
            EyeDraw.texture(matrices, this.icon, x + this.offset, y + this.offset, this.width - this.offset * 2, this.height - this.offset * 2, this.secondary);
        }
    }

    public Image getIcon() {
        return this.icon;
    }
}

